package bpm.gateway.core.veolia.patrimoine.xls;

import bpm.gateway.core.veolia.VEHelper;

public enum ListeUniteType {

	ESPACES_VERTS("Espaces verts"),
	SCURIT("Scurit"),
	GNIE_CIVIL("Gnie-Civil"),
	ELECTRICIT("Electricit"),
	HUISSERIES("Huisseries"),
	HYDRAULIQUE("Hydraulique"),
	COMPTAGE("Comptage"),
	RGULATION("Rgulation"),
	MTROLOGIE("Mtrologie"),
	TLGESTION("Tlgestion"),
	VENTILATION("Ventilation"),
	EQUIPEMENTS_PDAGOGIQUES("Equipements pdagogiques"),
	POMPAGE_EXHAURE("Pompage / Exhaure"),
	CHLORATION_STRILISATION("Chloration / Strilisation"),
	PROTECTION_CATHODIQUE("Protection cathodique"),
	FLOTTATION_DCANTATION("Flottation / dcantation"),
	CONDITIONNEMENT_MINRALISATION("Conditionnement/Minralisation"),
	FILTRATION("Filtration"),
	OXYDATION("Oxydation"),
	ULTRAFILTRATION_ULTRA_VIOLET("Ultrafiltration/Ultra violet"),
	RECIRCULATION("Recirculation"),
	COLLECTE_EAUX_DE_PROCESS("Collecte eaux de process"),
	TRAITEMENT_TERRES_DSHYDRATATION("Traitement terres/dshydratation"),
	SCHAGE_TERRES("Schage terres"),
	RACTIFS("Ractifs"),
	INFORMATIQUE("Informatique"),
	AIR_DE_SERVICE("Air de service"),
	EAU_DE_SERVICE("Eau de service"),
	LABORATOIRE("Laboratoire"),
	ENERGIE_RENOUVELABLE("Energie renouvelable"),
	UTILITS("Utilits"),
	EQUIPEMENTS_DIVERS("Equipements divers"),
	STATION_DE_PRODUCTION_DLECTRICIT("Station de Production d'lectricit"),
	AUTOMATISME("Automatisme"),
	VANTELLERIE("Vantellerie"),
	EAUX_USES("Eaux uses"),
	EAUX_PLUVIALES("Eaux pluviales"),
	CHARBON("Charbon"),
	STATION_LIMNIMTRIQUE("Station Limnimtrique"),
	MANUTENTION("Manutention"),
	SERRURERIE("Serrurerie"),
	PROTECTION_HYDRAULIQUE("Protection hydraulique"),
	NR("NR");
    private final String value;

    ListeUniteType(String v) {
        value = v;
    }
	
    public static String getValue(String table, String champ, ListeUniteType v, boolean required) {
    	if (required && v == null) {
    		throw new IllegalArgumentException("Table " + table + " - Champs " + champ + " - Valeur 'Null' ou non permise pour la liste.");
    	}
    	return v != null ? v.value : null;
    }
    
    public static ListeUniteType fromValue(String table, String champ, String v) {
    	if (v == null) {
    		System.out.println("Table " + table + " - Champs " + champ + " - Valeur 'Null' non permise.");
    		return ListeUniteType.NR;
    	}
    	
        for (ListeUniteType c: ListeUniteType.values()) {
        	if (VEHelper.checkEnum(c.value, v)) {
        		return c;
        	}
        }
		System.out.println("Table " + table + " - Champs " + champ + " - Mauvaise valeur '" + v + "'");
		return ListeUniteType.NR;
    }

}
