package bpm.gateway.core.veolia.patrimoine.xls;

import bpm.gateway.core.veolia.VEHelper;

public enum ListeSiteCommune {

	MACHECOUL("Machecoul"),
	COULON("Coulon"),
	L_Aiguillon_sur_Mer("L'Aiguillon-sur-Mer"),
	L_Aiguillon_sur_Vie("L'Aiguillon-sur-Vie"),
	Aizenay("Aizenay"),
	Angles("Angles"),
	Antigny("Antigny"),
	Apremont("Apremont"),
	Aubigny_Aubigny_Les_Clouzeaux("Aubigny - Aubigny - Les Clouzeaux"),
	Auzay_Auchay_sur_Vende("Auzay - Auchay sur Vende"),
	Avrill("Avrill"),
	Barbtre("Barbtre"),
	La_Barre_de_Monts("La Barre-de-Monts"),
	Bazoges_en_Paillers("Bazoges-en-Paillers"),
	Bazoges_en_Pareds("Bazoges-en-Pareds"),
	Beaufou("Beaufou"),
	Beaulieu_sous_la_Roche("Beaulieu-sous-la-Roche"),
	Beaurepaire("Beaurepaire"),
	Beauvoir_sur_Mer("Beauvoir-sur-Mer"),
	Belleville_sur_Vie_Bellivigny("Belleville-sur-Vie - Bellivigny"),
	Benet("Benet"),
	La_Bernardire("La Bernardire"),
	Le_Bernard("Le Bernard"),
	Bessay("Bessay"),
	Bois_de_Cn("Bois-de-Cn"),
	La_Boissire_de_Montaigu("La Boissire-de-Montaigu"),
	La_Boissire_des_Landes("La Boissire-des-Landes"),
	Bouffr("Bouffr"),
	Bouill_Courdault("Bouill-Courdault"),
	Bouin("Bouin"),
	Boulogne_Essarts_en_Bocage("Boulogne - Essarts en Bocage"),
	Le_Boupre("Le Boupre"),
	Bourneau("Bourneau"),
	Bournezeau("Bournezeau"),
	Bretignolles_sur_Mer("Bretignolles-sur-Mer"),
	La_Bretonnire_la_Claye("La_Bretonnire-la-Claye"),
	Breuil_Barret("Breuil-Barret"),
	Les_Brouzils("Les Brouzils"),
	La_Bruffire("La Bruffire"),
	La_Caillre_Saint_Hilaire("La Caillre-Saint-Hilaire"),
	Cezais("Cezais"),
	Chaill_les_Marais("Chaill-les-Marais"),
	Chaill_sous_les_Ormeaux_Rives_de_l_Yon("Chaill-sous-les-Ormeaux - Rives de l'Yon"),
	Chaix_Auchay_sur_Vende("Chaix - Auchay sur Vende"),
	La_Chaize_Giraud("La Chaize-Giraud"),
	La_Chaize_le_Vicomte("La Chaize-le-Vicomte"),
	Challans("Challans"),
	Chambretaud("Chambretaud"),
	Champagn_les_Marais("Champagn-les-Marais"),
	Le_Champ_Saint_Pre("Le Champ-Saint-Pre"),
	Chantonnay("Chantonnay"),
	La_Chapelle_Achard_Les_Achards("La Chapelle-Achard - Les Achards"),
	La_Chapelle_aux_Lys("La Chapelle-aux-Lys"),
	La_Chapelle_Hermier("La Chapelle-Hermier"),
	La_Chapelle_Palluau("La Chapelle-Palluau"),
	La_Chapelle_Thmer("La Chapelle-Thmer"),
	Chasnais("Chasnais"),
	La_Chtaigneraie("La Chtaigneraie"),
	Chteau_d_Olonne("Chteau-d'Olonne"),
	Chteau_Guibert("Chteau-Guibert"),
	Chteauneuf("Chteauneuf"),
	Les_Chtelliers_Chteaumur_Svremont("Les Chtelliers-Chteaumur  - Svremont"),
	Chauch("Chauch"),
	Chavagnes_en_Paillers("Chavagnes-en-Paillers"),
	Chavagnes_les_Redoux("Chavagnes-les-Redoux"),
	Cheffois("Cheffois"),
	Les_Clouzeaux_Aubigny_Les_Clouzeaux("Les Clouzeaux  - Aubigny - Les Clouzeaux"),
	Cox("Cox"),
	Commequiers("Commequiers"),
	La_Copechagnire("La Copechagnire"),
	Corpe("Corpe"),
	La_Couture("La Couture"),
	Cugand("Cugand"),
	Curzon("Curzon"),
	Damvix("Damvix"),
	Doix_Doix_les_Fontaines("Doix - Doix les Fontaines"),
	Dompierre_sur_Yon("Dompierre-sur-Yon"),
	Les_Epesses("Les Epesses"),
	L_pine("L'pine"),
	Les_Essarts_Essarts_en_Bocage("Les Essarts  - Essarts en Bocage"),
	Falleron("Falleron"),
	Faymoreau("Faymoreau"),
	Le_Fenouiller("Le Fenouiller"),
	La_Ferrire("La Ferrire"),
	La_Flocellire_Svremont("La Flocellire - Svremont"),
	Fontaines_Doix_les_Fontaines("Fontaines  - Doix les Fontaines"),
	Fontenay_le_Comte("Fontenay-le-Comte"),
	Fouger("Fouger"),
	Foussais_Payr("Foussais-Payr"),
	Froidfond("Froidfond"),
	La_Garnache("La Garnache"),
	La_Gaubretire("La Gaubretire"),
	La_Gntouze("La Gntouze"),
	Le_Girouard("Le Girouard"),
	Givrand("Givrand"),
	Le_Givre("Le Givre"),
	Grand_Landes("Grand'Landes"),
	Grosbreuil("Grosbreuil"),
	Grues("Grues"),
	Le_Gu_de_Velluire("Le Gu-de-Velluire"),
	La_Gurinire("La Gurinire"),
	La_Guyonnire("La Guyonnire"),
	L_Herbergement("L'Herbergement"),
	Les_Herbiers("Les Herbiers"),
	L_Hermenault("L'Hermenault"),
	L_le_d_Elle("L'le-d'Elle"),
	L_le_d_Olonne("L'le-d'Olonne"),
	L_le_d_Yeu("L'le-d'Yeu"),
	Jard_sur_Mer("Jard-sur-Mer"),
	La_Jaudonnire("La Jaudonnire"),
	La_Jonchre("La Jonchre"),
	Lairoux("Lairoux"),
	Landeronde("Landeronde"),
	Les_Landes_Genusson("Les Landes-Genusson"),
	Landevieille("Landevieille"),
	Le_Langon("Le Langon"),
	Liez("Liez"),
	Loge_Fougereuse("Loge-Fougereuse"),
	Longves("Longves"),
	Longeville_sur_Mer("Longeville-sur-Mer"),
	Luon("Luon"),
	Les_Lucs_sur_Boulogne("Les Lucs-sur-Boulogne"),
	Mach("Mach"),
	Les_Magnils_Reigniers("Les Magnils-Reigniers"),
	Maill("Maill"),
	Maillezais("Maillezais"),
	Mallivre("Mallivre"),
	Mareuil_sur_Lay_Dissais("Mareuil-sur-Lay-Dissais"),
	Marillet("Marillet"),
	Marsais_Sainte_Radgonde("Marsais-Sainte-Radgonde"),
	Martinet("Martinet"),
	Le_Mazeau("Le Mazeau"),
	La_Meilleraie_Tillay("La Meilleraie-Tillay"),
	Menomblet("Menomblet"),
	La_Merlatire("La Merlatire"),
	Mervent("Mervent"),
	Mesnard_la_Barotire("Mesnard-la-Barotire"),
	Monsireigne("Monsireigne"),
	Montaigu("Montaigu"),
	Montournais("Montournais"),
	Montreuil("Montreuil"),
	Moreilles("Moreilles"),
	Mormaison_Montrverd("Mormaison - Montrverd"),
	Mortagne_sur_Svre("Mortagne-sur-Svre"),
	La_Mothe_Achard_Les_Achards("La Mothe-Achard - Les Achards"),
	Mouchamps("Mouchamps"),
	Mouilleron_en_Pareds_Mouilleron_Saint_Germain("Mouilleron-en-Pareds - Mouilleron Saint Germain"),
	Mouilleron_le_Captif("Mouilleron-le-Captif"),
	Moutiers_les_Mauxfaits("Moutiers-les-Mauxfaits"),
	Moutiers_sur_le_Lay("Moutiers-sur-le-Lay"),
	Mouzeuil_Saint_Martin("Mouzeuil-Saint-Martin"),
	Nalliers("Nalliers"),
	Nesmy("Nesmy"),
	Nieul_le_Dolent("Nieul-le-Dolent"),
	Nieul_sur_l_Autise("Nieul-sur-l'Autise"),
	Noirmoutier_en_l_le("Noirmoutier-en-l'le"),
	Notre_Dame_de_Monts("Notre-Dame-de-Monts"),
	L_Oie_Essarts_en_Bocage("L'Oie  - Essarts en Bocage"),
	Olonne_sur_Mer("Olonne-sur-Mer"),
	L_Orbrie("L'Orbrie"),
	Oulmes("Oulmes"),
	Palluau("Palluau"),
	Pault("Pault"),
	Le_Perrier("Le Perrier"),
	Petosse("Petosse"),
	Les_Pineaux("Les Pineaux"),
	Pissotte("Pissotte"),
	Le_Poir_sur_Velluire("Le Poir-sur-Velluire"),
	Le_Poir_sur_Vie("Le Poir-sur-Vie"),
	Poiroux("Poiroux"),
	La_Pommeraie_sur_Svre_Svremont("La Pommeraie-sur-Svre  - Svremont"),
	Pouill("Pouill"),
	Pouzauges("Pouzauges"),
	Puy_de_Serre("Puy-de-Serre"),
	Puyravault("Puyravault"),
	La_Rabatelire("La Rabatelire"),
	Raumur("Raumur"),
	La_Rorthe("La Rorthe"),
	Notre_Dame_de_Riez("Notre-Dame-de-Riez"),
	Rocheservire("Rocheservire"),
	La_Roche_sur_Yon("La Roche-sur-Yon"),
	Rochetrejoux("Rochetrejoux"),
	Rosnay("Rosnay"),
	Les_Sables_d_Olonne("Les Sables-d'Olonne"),
	Saint_Andr_Goule_d_Oie("Saint-Andr-Goule-d'Oie"),
	Saint_Andr_Treize_Voies_Montrverd("Saint-Andr-Treize-Voies  - Montrverd"),
	Saint_Aubin_des_Ormeaux("Saint-Aubin-des-Ormeaux"),
	Saint_Aubin_la_Plaine("Saint-Aubin-la-Plaine"),
	Saint_Avaugourd_des_Landes("Saint-Avaugourd-des-Landes"),
	Saint_Benoist_sur_Mer("Saint-Benoist-sur-Mer"),
	Sainte_Ccile("Sainte-Ccile"),
	Saint_Christophe_du_Ligneron("Saint-Christophe-du-Ligneron"),
	Saint_Cyr_des_Gts("Saint-Cyr-des-Gts"),
	Saint_Cyr_en_Talmondais("Saint-Cyr-en-Talmondais"),
	Saint_Denis_du_Payr("Saint-Denis-du-Payr"),
	Saint_Denis_la_Chevasse("Saint-Denis-la-Chevasse"),
	Saint_tienne_de_Brillouet("Saint-tienne-de-Brillouet"),
	Saint_tienne_du_Bois("Saint-tienne-du-Bois"),
	Sainte_Flaive_des_Loups("Sainte-Flaive-des-Loups"),
	Sainte_Florence_Essarts_en_Bocage("Sainte-Florence  - Essarts en Bocage"),
	Saint_Florent_des_Bois_Rives_de_l_Yon("Saint-Florent-des-Bois  - Rives de l'Yon"),
	Sainte_Foy("Sainte-Foy"),
	Saint_Fulgent("Saint-Fulgent"),
	Sainte_Gemme_la_Plaine("Sainte-Gemme-la-Plaine"),
	Saint_Georges_de_Montaigu("Saint-Georges-de-Montaigu"),
	Saint_Georges_de_Pointindoux("Saint-Georges-de-Pointindoux"),
	Saint_Germain_l_Aiguiller_Mouilleron_Saint_Germain("Saint-Germain-l'Aiguiller  - Mouilleron Saint Germain"),
	Saint_Germain_de_Prinay("Saint-Germain-de-Prinay"),
	Saint_Gervais("Saint-Gervais"),
	Saint_Gilles_Croix_de_Vie("Saint-Gilles-Croix-de-Vie"),
	Sainte_Hermine("Sainte-Hermine"),
	Saint_Hilaire_de_Loulay("Saint-Hilaire-de-Loulay"),
	Saint_Hilaire_de_Riez("Saint-Hilaire-de-Riez"),
	Saint_Hilaire_des_Loges("Saint-Hilaire-des-Loges"),
	Saint_Hilaire_de_Voust("Saint-Hilaire-de-Voust"),
	Saint_Hilaire_la_Fort("Saint-Hilaire-la-Fort"),
	Saint_Hilaire_le_Vouhis("Saint-Hilaire-le-Vouhis"),
	Saint_Jean_de_Beugn("Saint-Jean-de-Beugn"),
	Saint_Jean_de_Monts("Saint-Jean-de-Monts"),
	Saint_Juire_Champgillon("Saint-Juire-Champgillon"),
	Saint_Julien_des_Landes("Saint-Julien-des-Landes"),
	Saint_Laurent_de_la_Salle("Saint-Laurent-de-la-Salle"),
	Saint_Laurent_sur_Svre("Saint-Laurent-sur-Svre"),
	Saint_Maixent_sur_Vie("Saint-Maixent-sur-Vie"),
	Saint_Mal_du_Bois("Saint-Mal-du-Bois"),
	Saint_Mars_la_Rorthe("Saint-Mars-la-Rorthe"),
	Brem_sur_Mer("Brem-sur-Mer"),
	Saint_Martin_de_Fraigneau("Saint-Martin-de-Fraigneau"),
	Saint_Martin_des_Fontaines("Saint-Martin-des-Fontaines"),
	Saint_Martin_des_Noyers("Saint-Martin-des-Noyers"),
	Saint_Martin_des_Tilleuls("Saint-Martin-des-Tilleuls"),
	Saint_Martin_Lars_en_Sainte_Hermine("Saint-Martin-Lars-en-Sainte-Hermine"),
	Saint_Mathurin("Saint-Mathurin"),
	Saint_Maurice_des_Noues("Saint-Maurice-des-Noues"),
	Saint_Maurice_le_Girard("Saint-Maurice-le-Girard"),
	Saint_Mesmin("Saint-Mesmin"),
	Saint_Michel_en_l_Herm("Saint-Michel-en-l'Herm"),
	Saint_Michel_le_Cloucq("Saint-Michel-le-Cloucq"),
	Saint_Michel_Mont_Mercure_Svremont("Saint-Michel-Mont-Mercure  - Svremont"),
	Saint_Paul_en_Pareds("Saint-Paul-en-Pareds"),
	Saint_Paul_Mont_Penit("Saint-Paul-Mont-Penit"),
	Sainte_Pexine("Sainte-Pexine"),
	Saint_Philbert_de_Bouaine("Saint-Philbert-de-Bouaine"),
	Saint_Pierre_du_Chemin("Saint-Pierre-du-Chemin"),
	Saint_Pierre_le_Vieux("Saint-Pierre-le-Vieux"),
	Saint_Prouant("Saint-Prouant"),
	Sainte_Radgonde_des_Noyers("Sainte-Radgonde-des-Noyers"),
	Saint_Rvrend("Saint-Rvrend"),
	Saint_Sigismond("Saint-Sigismond"),
	Saint_Sulpice_en_Pareds("Saint-Sulpice-en-Pareds"),
	Saint_Sulpice_le_Verdon_Montrverd("Saint-Sulpice-le-Verdon  - Montrverd"),
	Saint_Urbain("Saint-Urbain"),
	Saint_Valrien("Saint-Valrien"),
	Saint_Vincent_Sterlanges("Saint-Vincent-Sterlanges"),
	Saint_Vincent_sur_Graon("Saint-Vincent-sur-Graon"),
	Saint_Vincent_sur_Jard("Saint-Vincent-sur-Jard"),
	Saligny_Bellivigny("Saligny - Bellivigny"),
	Sallertaine("Sallertaine"),
	Srign("Srign"),
	Sigournais("Sigournais"),
	Soullans("Soullans"),
	Le_Tablier("Le Tablier"),
	La_Taille("La Taille"),
	Tallud_Sainte_Gemme("Tallud-Sainte-Gemme"),
	Talmont_Saint_Hilaire("Talmont-Saint-Hilaire"),
	La_Tardire("La Tardire"),
	Thir("Thir"),
	Thorigny("Thorigny"),
	Thouarsais_Bouildroux("Thouarsais-Bouildroux"),
	Tiffauges("Tiffauges"),
	La_Tranche_sur_Mer("La Tranche-sur-Mer"),
	Treize_Septiers("Treize-Septiers"),
	Treize_Vents("Treize-Vents"),
	Triaize("Triaize"),
	Vair("Vair"),
	Velluire("Velluire"),
	Venansault("Venansault"),
	Vendrennes("Vendrennes"),
	La_Verrie("La Verrie"),
	Vix("Vix"),
	Vouill_les_Marais("Vouill-les-Marais"),
	Vouvant("Vouvant"),
	Xanton_Chassenon("Xanton-Chassenon"),
	La_Faute_sur_Mer("La Faute-sur-Mer");
    private final String value;

    ListeSiteCommune(String v) {
        value = v;
    }
	
    public static String getValue(String table, String champ, ListeSiteCommune v, boolean required) {
    	if (required && v == null) {
    		throw new IllegalArgumentException("Table " + table + " - Champs " + champ + " - Valeur 'Null' ou non permise pour la liste.");
    	}
    	return v != null ? v.value : null;
    }
    
    public static ListeSiteCommune fromValue(String table, String champ, String v) {
    	if (v == null) {
    		System.out.println("Table " + table + " - Champs " + champ + " - Valeur 'Null' non permise.");
    		return null;
    	}
    	
        for (ListeSiteCommune c: ListeSiteCommune.values()) {
        	if (VEHelper.checkEnum(c.value, v)) {
        		return c;
        	}
        }
		System.out.println("Table " + table + " - Champs " + champ + " - Mauvaise valeur '" + v + "'");
		return null;
    }

}
