package bpm.gateway.core.veolia.patrimoine.xls;

import bpm.gateway.core.veolia.VEHelper;

public enum ListeContratExploitant {

	NANTAISE_DES_EAUX("Nantaise des Eaux"),
	SAUR("SAUR"),
	STGS("STGS"),
	SUEZ("SUEZ"),
	VEOLIA("VEOLIA"),
	NR("NR");
    private final String value;

    ListeContratExploitant(String v) {
        value = v;
    }
	
    public static String getValue(String table, String champ, ListeContratExploitant v, boolean required) {
    	if (required && v == null) {
    		throw new IllegalArgumentException("Table " + table + " - Champs " + champ + " - Valeur 'Null' ou non permise pour la liste.");
    	}
    	return v != null ? v.value : null;
    }
    
    public static ListeContratExploitant fromValue(String table, String champ, String v) {
    	if (v == null) {
    		System.out.println("Table " + table + " - Champs " + champ + " - Valeur 'Null' non permise.");
    		return ListeContratExploitant.NR;
    	}
    	
        for (ListeContratExploitant c: ListeContratExploitant.values()) {
        	if (VEHelper.checkEnum(c.value, v)) {
        		return c;
        	}
        }
		System.out.println("Table " + table + " - Champs " + champ + " - Mauvaise valeur '" + v + "'");
		return ListeContratExploitant.NR;
    }

}
