package bpm.gateway.core.veolia.patrimoine.xls;

import bpm.gateway.core.veolia.VEHelper;

public enum ListeCaptageAquifere {

	CALCAIRES_GRSEAUX_DOLOMITIQUES_DU_LIAS_INFRIEUR("Calcaires grseaux dolomitiques du Lias Infrieur"),
	SOCLE_GRANITIQUE_DE_TYPE_FISSUR("Socle granitique de type fissur"),
	ARGILE_SABLEUX_ET_ARNE_GRANITIQUE_SOUSJACENTE("Argile sableux et arne granitique sous-jacente"),
	ALTERNANCE_DE_GRANITES_ET_CORNENNES_FRACTURES("Alternance de granites et cornennes fractures"),
	CALCAIRES_GRSEAUX_DGE_OCNE("Calcaires grseaux d'ge ocne"),
	ALTRITE_SCHISTEUSE_SOUSJACENT("Altrite schisteuse sous-jacent"),
	ALTRITE_SCHISTEUSE_SOUSJACENT_ET_SCHISTE_FISSUR("altrite schisteuse sous-jacent et schiste fissur"),
	FORMATIONS_ISSUES_DE_LALTRATION_DES_RHYOLITES_ET_IGNIMBRITES("Formations issues de l'altration des rhyolites et ignimbrites"),
	SCHISTE_ALTR_ET_FISSUR("Schiste altr et fissur"),
	CALCAIRES_FISSURS_DU_LIAS_INFRIEUR("Calcaires fissurs du Lias infrieur"),
	SCHISTE_ALTR_ET_FISSUR_SOUS_JACENT_AU_CALCAIRE("Schiste altr et fissur sous jacent au calcaire"),
	CALCAIRES_GRSEAUX_DU_LIAS_INFRIEUR("Calcaires grseaux du Lias Infrieur"),
	NR("NR");
    private final String value;

    ListeCaptageAquifere(String v) {
        value = v;
    }
	
    public static String getValue(String table, String champ, ListeCaptageAquifere v, boolean required) {
    	if (required && v == null) {
    		throw new IllegalArgumentException("Table " + table + " - Champs " + champ + " - Valeur 'Null' ou non permise pour la liste.");
    	}
    	return v != null ? v.value : null;
    }
    
    public static ListeCaptageAquifere fromValue(String table, String champ, String v) {
    	if (v == null) {
    		System.out.println("Table " + table + " - Champs " + champ + " - Valeur 'Null' non permise.");
    		return ListeCaptageAquifere.NR;
    	}
    	
        for (ListeCaptageAquifere c: ListeCaptageAquifere.values()) {
        	if (VEHelper.checkEnum(c.value, v)) {
        		return c;
        	}
        }
		System.out.println("Table " + table + " - Champs " + champ + " - Mauvaise valeur '" + v + "'");
		return ListeCaptageAquifere.NR;
    }

}
