package bpm.gateway.core.tools;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLHelper {

	@SuppressWarnings("unchecked")
	public static Set<String> extractColumnPaths(Document doc, String baseXPath) {
		Set<String> paths = new LinkedHashSet<>();
		List<Element> nodes = doc.selectNodes(baseXPath);

		for (Element baseNode : nodes) {
			collectPaths(baseNode, "", paths);
		}

		return paths;
	}

	@SuppressWarnings("unchecked")
	private static void collectPaths(Element element, String path, Set<String> paths) {
		String nodeName = element.getName();
		String currentPath = path.isEmpty() ? nodeName : path + "." + nodeName;

		List<Attribute> attributes = element.attributes();
		for (Attribute attr : attributes) {
		    paths.add(currentPath + ".@" + attr.getName());
		}

		// Recurse into child elements
		List<Element> children = element.elements();
		boolean hasElementChild = !children.isEmpty();

		for (Element child : children) {
			collectPaths(child, currentPath, paths);
		}

		// Add text content if leaf
		if (!hasElementChild && element.getTextTrim().length() > 0) {
			paths.add(currentPath);
		}
	}

	@SuppressWarnings("unchecked")
	public static List<Map<String, String>> extractDataRows(Document doc, String baseXPath, Set<String> columns) {
		List<Map<String, String>> rows = new ArrayList<>();
		List<Node> nodes = doc.selectNodes(baseXPath);

		for (Node currentNode : nodes) {
			Map<String, String> row = extractDataRow(currentNode, columns);
			rows.add(row);
		}

		return rows;
	}
	
	public static Map<String, String> extractDataRow(Node currentNode, Set<String> columns) {
        Map<String, String> row = new LinkedHashMap<>();

        for (String column : columns) {
            String relativePath = column.contains(".") ? column.substring(column.indexOf('.') + 1) : column;
            String xPathExpr = relativePath.replace(".", "/").replaceAll("/@", "/@");
            
            Node result = currentNode.selectSingleNode(xPathExpr);
            String value = "";

            if (result != null) {
                if (result instanceof Attribute) {
                    value = ((Attribute) result).getValue();
                } else {
                    value = result.getText();
                }
            }

            row.put(column, value);
        }

        return row;
	}
}
