package bpm.gateway.core;
import org.w3c.dom.*;
import javax.xml.xpath.*;
import java.util.*;

public class XmlValueExtractor {

    private final XPath xpath;

    public XmlValueExtractor() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xpath = xPathFactory.newXPath();
    }

    /**
     * Extract values from a given XML node using a list of column paths
     */
    public Map<String, String> extractValues(Node contextNode, Set<String> columnPaths) throws XPathExpressionException {
        Map<String, String> values = new LinkedHashMap<>();

        for (String path : columnPaths) {
            String xpathExpr = buildXPathFromPath(path);
            String value = evaluateXPath(xpathExpr, contextNode);
            values.put(path, value);
        }

        return values;
    }

    /**
     * Translates a column path like CptBancaire.BIC.@V into XPath: ./CptBancaire/BIC/@V
     */
    private String buildXPathFromPath(String path) {
        String[] parts = path.split("\\.");
        StringBuilder xpathBuilder = new StringBuilder(".");

        for (String part : parts) {
            if (part.startsWith("@")) {
                xpathBuilder.append("/").append(part); // attribute at current level
            } else {
                xpathBuilder.append("/").append(part);
            }
        }

        return xpathBuilder.toString();
    }

    /**
     * Evaluate an XPath expression relative to a given node
     */
    private String evaluateXPath(String xpathExpr, Node contextNode) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(xpathExpr);
        String result = expr.evaluate(contextNode).trim();
        return result.isEmpty() ? "" : result;
    }
}
