package bpm.gateway.core;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.xml.xpath.*;
import java.io.File;
import java.util.*;

public class XmlColumnExtractor {

	/**
	 * Extracts all possible column paths under nodes matching the XPath (e.g.,
	 * //Agent)
	 */
	public static Set<String> extractColumns(File xmlFile, String xpathExpr) throws Exception {
		Set<String> columns = new LinkedHashSet<>();

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setNamespaceAware(true);
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document doc = builder.parse(xmlFile);

		XPathFactory xPathFactory = XPathFactory.newInstance();
		XPath xpath = xPathFactory.newXPath();
		NodeList nodes = (NodeList) xpath.compile(xpathExpr).evaluate(doc, XPathConstants.NODESET);

		for (int i = 0; i < nodes.getLength(); i++) {
			Node baseNode = nodes.item(i);
			extractPathsRecursively(baseNode, "", columns);
		}

		return columns;
	}

	/**
	 * Recursively build paths like CptBancaire.BIC.@V or Matricule.@V
	 */
	private static void extractPathsRecursively(Node node, String prefix, Set<String> columns) {
	    if (node.getNodeType() != Node.ELEMENT_NODE) return;

	    Element element = (Element) node;
	    String currentPath = prefix.isEmpty() ? element.getNodeName() : prefix + "." + element.getNodeName();

	    // Add attributes
	    NamedNodeMap attributes = element.getAttributes();
	    for (int i = 0; i < attributes.getLength(); i++) {
	        Node attr = attributes.item(i);
	        columns.add(currentPath + ".@" + attr.getNodeName());
	    }

	    NodeList children = element.getChildNodes();
	    boolean hasElementChildren = false;

	    for (int i = 0; i < children.getLength(); i++) {
	        Node child = children.item(i);
	        if (child.getNodeType() == Node.ELEMENT_NODE) {
	            hasElementChildren = true;
	            extractPathsRecursively(child, currentPath, columns);
	        }
	    }

	    // Add text content if it's a leaf node with text
	    if (!hasElementChildren && element.getTextContent() != null && !element.getTextContent().trim().isEmpty()) {
	        columns.add(currentPath);
	    }
	}

}
