package bpm.gateway.runtime2.transformations.outputs;

import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import bpm.gateway.core.transformations.outputs.GeoJsonOutput;
import bpm.gateway.runtime2.RuntimeStep;
import bpm.gateway.runtime2.internal.Row;

public class RunGeoJsonOutput extends RuntimeStep {

	private GeoJson json = new GeoJson();
	
	public RunGeoJsonOutput(GeoJsonOutput transformation, int bufferSize) {
		super(null, transformation, bufferSize);
	}

	@Override
	public void performRow() throws Exception {
		if (areInputStepAllProcessed()){
			if (inputEmpty()){
				setEnd();
			}
		}
		
		if (isEnd() && inputEmpty()){
			return;
		}
		
		if (!isEnd() && inputEmpty()){
			  try {
			      Thread.sleep(10);
			  }
			  catch (InterruptedException e) {
			       Thread.currentThread().interrupt(); // restore interrupted status
			  }
			return;
		}
		
		
		Row row = readRow();
		
		if (row == null){
			return;
		}
		
		boolean onlyOneColumn = ((GeoJsonOutput) transformation).isOnlyOneColumn();
		int indexLat = inputs.get(0).getTransformation().getDescriptor(null).getElementIndex(((GeoJsonOutput)transformation).getLatitudeColumn());
		int indexLong = !onlyOneColumn ? inputs.get(0).getTransformation().getDescriptor(null).getElementIndex(((GeoJsonOutput)transformation).getLongitudeColumn()) : -1;
		
		Double lat = null;
		Double longi = null;
		
		if (onlyOneColumn) {
			String coordinates = row.get(indexLat).toString();
			
			String[] coords = coordinates.split(",");
			lat = Double.parseDouble(coords[0]);
			longi = Double.parseDouble(coords[1]);
		}
		else {
			lat = Double.parseDouble(row.get(indexLat).toString());
			longi = Double.parseDouble(row.get(indexLong).toString());
		}
		
		List<Property> props = new ArrayList<>();
		for(int i = 0 ; i < row.getMeta().getSize() ; i++) {
			if(i != indexLat && i != indexLong) {
				Property p = new Property();
				p.setName(inputs.get(0).getTransformation().getDescriptor(null).getColumnName(i));
				try {
					p.setValue(row.get(i).toString());
				} catch(Exception e) {
					p.setValue("");
				}
				props.add(p);
			}
		}
		
		
		Feature feature = null;
		if(((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_POINT)) {
			feature = new Feature();
			
			GeoPoint geometry = new GeoPoint();
			geometry.setType(((GeoJsonOutput)transformation).getGeometryType());
			geometry.setCoordinates(new Double[]{lat, longi});
			feature.setGeometry(geometry);
			
			json.getFeatures().add(feature);
		}
		else {
			if(((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_LINESTRING) || ((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_MULTIPOINT) || ((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_POLYGON)) {
				feature = getFeature(props);
				if(feature == null) {
					feature = new Feature();
					json.getFeatures().add(feature);
				}
				if(feature.getGeometry() == null) {
					GeoLineMultiPoint geo = new GeoLineMultiPoint();
					geo.setType(((GeoJsonOutput)transformation).getGeometryType());
					feature.setGeometry(geo);
				}
				((GeoLineMultiPoint)feature.getGeometry()).getCoordinates().add(new Double[]{lat, longi});
			}
//			else if(((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_POLYGON) || ((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_MULTILINESTRING)) {
//				Feature f = getFeature(props);
//				if(f.getGeometry() == null) {
//					GeoPolygonMultiLine geo = new GeoPolygonMultiLine();
//					geo.setType(((GeoJsonOutput)transformation).getGeometryType());
//					f.setGeometry(geo);
//				}
//				((GeoPolygonMultiLine)f.getGeometry()).getCoordinates().add(new String[]{lat, longi});
//			}
//			else if(((GeoJsonOutput)transformation).getGeometryType().equals(GeoJsonOutput.TYPE_MULTIPOLYGON)) {
//				
//			}
		}
		
		for(Property p : props) {
			feature.addProperty(p.getName(), p.getValue());
		}
	}

	private Feature getFeature(List<Property> props) {
		return json.getFeatureByProps(props);
	}

	@Override
	public void releaseResources() {
		GsonBuilder gsonBuilder = new GsonBuilder();
		gsonBuilder.registerTypeAdapter(Property.class, new JsonSerializer<Property>() {

			@Override
			public JsonElement serialize(Property arg0, Type arg1, JsonSerializationContext arg2) {
				JsonObject jsonObj = new JsonObject();

				jsonObj.addProperty(arg0.getName(), arg0.getValue());

		        return jsonObj;
			}
		});
		Gson gson = gsonBuilder.create();
		String result = gson.toJson(json);
		
		try {
			String fileName = ((GeoJsonOutput)transformation).getDocument().getStringParser().getValue(getTransformation().getDocument(), ((GeoJsonOutput)transformation).getFilePath());
			Files.write(Paths.get(fileName), result.getBytes());
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void init(Object adapter) throws Exception {
		json = new GeoJson();
	}

	public class GeoJson {
		private String type = "FeatureCollection";
		private List<Feature> features = new ArrayList<>();

		public String getType() {
			return type;
		}

		public Feature getFeatureByProps(List<Property> props) {
			LOOP:for(Feature f : features) {
				for(Property p : props) {
					if(!f.getProperties().containsKey(p.getValue())) {
						continue LOOP;
					}
				}
				return f;
			}
			return null;
		}

		public void setType(String type) {
			this.type = type;
		}

		public List<Feature> getFeatures() {
			return features;
		}

		public void setFeatures(List<Feature> features) {
			this.features = features;
		}

	}

	public class Feature {

	    private String type = "Feature";
	    private Geometry geometry;
	    private Map<String, String> properties = new LinkedHashMap<>(); // Changed to Map

	    public String getType() {
	        return type;
	    }

	    public void addProperty(String key, String value) { // Changed to key-value pairs
	        properties.put(key, value);
	    }

	    public void setType(String type) {
	        this.type = type;
	    }

	    public Geometry getGeometry() {
	        return geometry;
	    }

	    public void setGeometry(Geometry geometry) {
	        this.geometry = geometry;
	    }

	    public Map<String, String> getProperties() { // Changed to return Map
	        return properties;
	    }

	    public void setProperties(Map<String, String> properties) { // Changed parameter type to Map
	        this.properties = properties;
	    }
	}

	public abstract class Geometry {
		private String type;

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

	}

	public class GeoPoint extends Geometry {
		private Double[] coordinates;

		public Double[] getCoordinates() {
			return coordinates;
		}

		public void setCoordinates(Double[] coordinates) {
			this.coordinates = coordinates;
		}
	}

	public class GeoLineMultiPoint extends Geometry {
		private List<Double[]> coordinates = new ArrayList<>();

		public List<Double[]> getCoordinates() {
			return coordinates;
		}

		public void setCoordinates(List<Double[]> coordinates) {
			this.coordinates = coordinates;
		}

	}
	
	public class GeoPolygonMultiLine extends Geometry {
		private List<List<Double[]>> coordinates = new ArrayList<>();

		public List<List<Double[]>> getCoordinates() {
			return coordinates;
		}

		public void setCoordinates(List<List<Double[]>> coordinates) {
			this.coordinates = coordinates;
		}

	}
	
	public class GeoMultiPolygon extends Geometry {
		private List<List<List<Double[]>>> coordinates = new ArrayList<>();

		public List<List<List<Double[]>>> getCoordinates() {
			return coordinates;
		}

		public void setCoordinates(List<List<List<Double[]>>> coordinates) {
			this.coordinates = coordinates;
		}

	}

	public class Property {
		private String name;
		private String value;

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getValue() {
			return value;
		}

		public void setValue(String value) {
			this.value = value;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + getOuterType().hashCode();
			result = prime * result + ((name == null) ? 0 : name.hashCode());
			result = prime * result + ((value == null) ? 0 : value.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if(this == obj)
				return true;
			if(obj == null)
				return false;
			if(getClass() != obj.getClass())
				return false;
			Property other = (Property) obj;
			if(!getOuterType().equals(other.getOuterType()))
				return false;
			if(name == null) {
				if(other.name != null)
					return false;
			}
			else if(!name.equals(other.name))
				return false;
			if(value == null) {
				if(other.value != null)
					return false;
			}
			else if(!value.equals(other.value))
				return false;
			return true;
		}

		private RunGeoJsonOutput getOuterType() {
			return RunGeoJsonOutput.this;
		}

	}
}
