/*
 *************************************************************************
 * Copyright (c) 2009 <<Your Company Name here>>
 *  
 *************************************************************************
 */

package bpm.csv.oda.runtime.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

import bpm.csv.oda.runtime.datas.CsvColumn;

/**
 * Implementation class of IResultSetMetaData for an ODA runtime driver. <br>
 * For demo purpose, the auto-generated method stubs have hard-coded
 * implementation that returns a pre-defined set of meta-data and query results.
 * A custom ODA driver is expected to implement own data source specific
 * behavior in its place.
 */
public class ResultSetMetaData implements IResultSetMetaData {
	private Query query;
	private List<CsvColumn> columns = new ArrayList<CsvColumn>();
	private int numberOfRow = 0;

	public ResultSetMetaData(Query query) throws OdaException {
		this.query = query;
		File f = new File(this.query.getFilePath());
		try (FileInputStream is = new FileInputStream(f); BufferedReader reader = new BufferedReader(new InputStreamReader(is, query.getEncoding()))) {
			
			CSVFormat format = CSVFormat.newFormat(query.getSeparator().charAt(0)).withQuote('"');
			CSVParser parser = CSVParser.parse(reader, format);

			Iterator<CSVRecord> records = parser.iterator();
			this.columns = getHeader(records.next());

			int index = 1;
			while (records.hasNext()) {
				CSVRecord record = records.next();
				
				this.numberOfRow++;
				if (index > 100) {
					continue;
				}
				
				index++;
				
				// We tried to define the types of the columns
				
				for (CsvColumn column : columns) {
					String value = record.get(column.getPosition());
					
					if (value == null || value.isEmpty()) {
						continue;
					}
					
					try {
						Integer.parseInt(value);
						setType(column, Types.INTEGER);
						continue;
					} catch (NumberFormatException ex) { }

					try {
						Float.parseFloat(value);
						setType(column, Types.FLOAT);
						continue;
					} catch (NumberFormatException ex) {
						try {
							Float.parseFloat(value.replace(",", "."));
							setType(column, Types.FLOAT);
							continue;
						} catch (NumberFormatException x) { }
					}

					try {
						Double.parseDouble(value);
						setType(column, Types.DOUBLE);
						continue;
					} catch (NumberFormatException ex) {
						try {
							Double.parseDouble(value.replace(",", "."));
							setType(column, Types.DOUBLE);
							continue;
						} catch (NumberFormatException x) { }
					}

					try {
						if (isBoolean(value)) {
							setType(column, Types.BOOLEAN);
							continue;
						}
					} catch (NumberFormatException ex) { }

					setType(column, Types.CHAR);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new OdaException(e.getMessage());
		}
	}

	private List<CsvColumn> getHeader(CSVRecord record) {
		List<CsvColumn> headers = new ArrayList<CsvColumn>();
		for (int i = 0; i < record.size(); i++) {
			String header = record.get(i);
			
			CsvColumn c = new CsvColumn();
			c.setName(header);
			c.setPosition(i);
			headers.add(c);
		}
		return headers;
	}

	private void setType(CsvColumn csvColumn, int integer) throws Exception {
		if (csvColumn.getType() == Types.CHAR) {
			return;
		}
		csvColumn.setType(integer);

	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#getColumnCount(
	 * )
	 */
	public int getColumnCount() throws OdaException {
		if (query.getColumnIds().isEmpty()) {
			return columns.size();
		}
		return query.getColumnIds().size();
	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#getColumnName(
	 * int)
	 */
	public String getColumnName(int index) throws OdaException {
		if (query.getColumnIds().isEmpty()) {
			return columns.get(index).getName();
		}
		index = query.getColumnIds().get(index - 1);
		return columns.get(index).getName();
	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#getColumnLabel(
	 * int)
	 */
	public String getColumnLabel(int index) throws OdaException {
		return getColumnName(index); // default
	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#getColumnType(
	 * int)
	 */
	public int getColumnType(int index) throws OdaException {
		if (query.getColumnIds().isEmpty()) {
			return columns.get(index).getType();
		}
		index = query.getColumnIds().get(index - 1);
		return columns.get(index).getType();
	}

	/*
	 * @see org.eclipse.datatools.connectivity.oda.IResultSetMetaData#
	 * getColumnTypeName(int)
	 */
	public String getColumnTypeName(int index) throws OdaException {
		int nativeTypeCode = getColumnType(index);
		return Driver.getNativeDataTypeName(nativeTypeCode);
	}

	/*
	 * @see org.eclipse.datatools.connectivity.oda.IResultSetMetaData#
	 * getColumnDisplayLength(int)
	 */
	public int getColumnDisplayLength(int index) throws OdaException {
		if (query.getColumnIds().isEmpty()) {
			return columns.get(index).getName().length();
		}
		index = query.getColumnIds().get(index - 1);
		return columns.get(index).getName().length();
	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#getPrecision(
	 * int)
	 */
	public int getPrecision(int index) throws OdaException {

		return -1;
	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#getScale(int)
	 */
	public int getScale(int index) throws OdaException {

		return -1;
	}

	/*
	 * @see
	 * org.eclipse.datatools.connectivity.oda.IResultSetMetaData#isNullable(int)
	 */
	public int isNullable(int index) throws OdaException {

		return IResultSetMetaData.columnNullableUnknown;
	}

	private static boolean isBoolean(String s) {
		if (s == null || "true".equalsIgnoreCase(s.trim()) || "false".equalsIgnoreCase(s.trim()) || "1".equalsIgnoreCase(s.trim()) || "0".equals(s.trim())) {
			return true;
		}
		return false;
	}

	public List<CsvColumn> getColumns() {
		return columns;
	}

	public int getMaxRow() {
		return numberOfRow;
	}

}
