package bpm.document.management.core.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import bpm.document.management.core.model.User;
import bpm.vanilla.platform.core.config.ConfigurationManager;

public class EmailTemplate {
	
	private SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMM yyyy',' HH:mm:ss");
	private String propUrl = ConfigurationManager.getInstance().getVanillaConfiguration().getProperty("bpm.aklabox.external.server.url");

	public String getTemplate(User receiver, String aklaboxUrl, String content) {

		String templateType = ConfigurationManager.getProperty("bpm.document.management.mail.template");
		if(templateType == null || templateType.isEmpty()) {
			return getStandardTemplate(receiver, aklaboxUrl, content);
		}
		else if(templateType.equals("GPMG")){
			return getGPMGTemplate(receiver, aklaboxUrl, content);
		}

		return getStandardTemplate(receiver, aklaboxUrl, content);
	}
	
	private String getGPMGTemplate(User receiver, String aklaboxUrl, String content) {
		String text = "<html>";
		text += "<head><meta charset='UTF-8'></head>";
		text += "<body>";
		text += "<div style='padding: 10px;margin: 10px;background: white;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;border: 1px solid #d0d0d0;-webkit-box-shadow: 0 0 10px -5px black;-moz-box-shadow: 0 0 10px -5px black;box-shadow: 0 0 10px -5px black;'>";
		text += "<div style='width:100%;height:99%'>";
		text += "<div style='width: 98%;margin-left: 1%;min-height: 60px;background: #4dbfd9;'>";
		text += "<img style='width: 8%;margin-left: 0%;display: inline-block;vertical-align: middle;' src='http://guadeloupe-portcaraibes.com/wp-content/themes/guadeloupe-port-caraibes//img/logo.png' alt=''/>";
		text += "<div style='display: inline-block;vertical-align: middle;margin-left: 5%;color: #fff;width: 80%;text-align: center;font-weight: bolder;'><h2>GED</h2></div>";
		text += "</div>";
		text += "<div style='padding: 0 10px;margin: 10px;border: 1px solid #d0d0d0;-webkit-box-shadow: inset 0 0 10px -4px black;-moz-box-shadow: inset 0 0 10px -4px black;box-shadow: inset 0 0 10px -4px black;background: rgb(243, 243, 243);'>";
//		Date date = new Date();
//		date.setHours(date.getHours() - 6);
//		text += "<p>" + sdf.format(date) + "</p>";
		text += "<p>Bonjour "+ receiver.getFirstName() + " " + receiver.getLastName() +",</p>";
		text += "<p><i>" + content + "</i></p>";
		text += "<p>Pour vous connecter sur la plateforme cliquez sur le lien suivant <a href='" + propUrl + "'>Aklabox</a></p>";
		text += "<p>Merci!</p>";
		text += "<p>Cordialement,</p><p><b>Le Grand Port Maritime</b></p>";
		text += "</div>";
		text += "<div style='margin: 10px;padding: 0 10px; border-top: 10px solid #4dbfd9;'><p style='color: #868686;font-size: 10px;text-align:justify'>Copyright 2013-2018, BPM-Conseil. <a href='" + propUrl + "'>" + propUrl + "</a></p></div>";
		text += "</div>";
		text += "</body>";
		text += "</html>";
		
		return text;
	}

	private String getStandardTemplate(User receiver, String aklaboxUrl, String content) {
		String text = "<html>";
		text += "<head><meta charset='UTF-8'></head>";
		text += "<body>";
		text += "<div style='padding: 10px;margin: 10px;background: white;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;border: 1px solid #d0d0d0;-webkit-box-shadow: 0 0 10px -5px black;-moz-box-shadow: 0 0 10px -5px black;box-shadow: 0 0 10px -5px black;'>";
		text += "<div style='width:100%;height:99%'>";
		text += "<div style='width: 98%;margin-left: 1%;min-height: 60px;background: #4dbfd9;'>";
//		text += "<img style='width: 8%;margin-left: 5%;display: inline-block;vertical-align: middle;' src='http://91.121.167.76/aklabox/sites/default/files/allImages/aklabox-banner.png' alt='AKLABOX'/>";
//		text += "<img style='width: 8%;margin-left: 0%;display: inline-block;vertical-align: middle;' src='"+ getLogoDataUri() +"' alt='AKLABOX'/>";
		text += "<img style='width: 8%;margin-left: 0%;display: inline-block;vertical-align: middle;' src='http://www.aklabox.com/sites/default/files/AklaBox_2.png' alt='AKLABOX'/>";
//		text += "<div style='display: inline-block;vertical-align: middle;margin-left: 5%;color: #fff;width: 80%;text-align: center;font-weight: bolder;'><h2>AKLABOX (The Ultimate Document Management Experience)</h2></div>";
		text += "<div style='display: inline-block;vertical-align: middle;margin-left: 5%;color: #fff;width: 80%;text-align: center;font-weight: bolder;'><h2>AKLABOX</h2></div>";
		text += "</div>";
		// text += "<div style='overflow: hidden;'>";
		// text +=
		// "<div style='text-align:center;width:100%;'><img style='display: inline-block;vertical-align: middle;width: 50%;' src='http://91.121.167.76/aklabox/sites/default/files/allImages/aklabox-banner.png'/></div>";
		// text +=
		// "<div style='background: #3e9acc;color: white;padding: 10px;width: 100%;'>AKLABOX</div>";
		// text += "</div>";
		text += "<div style='padding: 0 10px;margin: 10px;border: 1px solid #d0d0d0;-webkit-box-shadow: inset 0 0 10px -4px black;-moz-box-shadow: inset 0 0 10px -4px black;box-shadow: inset 0 0 10px -4px black;background: rgb(243, 243, 243);'>";
//		Date date = new Date();
//		date = new Date(date.getTime() + TimeZone.getDefault().getOffset(date.getTime()));
		text += "<p>" + sdf.format(new Date()) + "</p>";
//		text += "<p>Cher Monsieur/Madame;</p>";
//		text += "<p>Bonjour!</p>";
		text += "<p>Bonjour "+ receiver.getFirstName() + " " + receiver.getLastName() +",</p>";
		text += "<p><i>" + content + "</i></p>";
		text += "<p>Merci!</p>";
		text += "<p>Cordialement,</p><p><b>L'équipe Aklabox</b></p>";
		text += "</div>";
		text += "<div style='margin: 10px;padding: 0 10px; border-top: 10px solid #4dbfd9;'><p style='color: #868686;font-size: 10px;text-align:justify'>Copyright 2013-2018, BPM-Conseil. <a href='" + propUrl + "'>" + propUrl + "</a></p></div>";
		text += "</div>";
		text += "</body>";
		text += "</html>";
		
		return text;
	}
	
	public String getLogoDataUri(){
		// logo_aklabox
		return "data:image/png;base64,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";
	}
}