/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.platform.hibernate;

import bpm.vanilla.platform.hibernate.BatchResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.factory.annotation.Autowired;

public class HibernateDaoSupport {
    private static final int BATCH_SIZE = 50;
    @Autowired
    private SessionFactory sessionFactory;
    private List<Object> objectToInsert;

    public HibernateDaoSupport getHibernateTemplate() {
        return this;
    }

    public void delete(Object obj) {
        Session session = this.getCurrentSession();
        try {
            Object res = session.merge(obj);
            session.delete(res);
            session.flush();
            session.clear();
            session.close();
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> void deleteAll(Collection<T> items) {
        for (T item : items) {
            this.delete(item);
        }
    }

    public Object saveOrUpdate(Object obj) {
        Session session = this.getCurrentSession();
        try {
            Object res = session.merge(obj);
            Transaction t = session.beginTransaction();
            session.saveOrUpdate(res);
            session.flush();
            t.commit();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public Serializable save(Object obj) {
        Session session = this.getCurrentSession();
        try {
            Serializable result = session.save(obj);
            session.flush();
            session.clear();
            session.close();
            return result;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public BatchResult saveBatch(Object obj, boolean end) {
        BatchResult result = new BatchResult();
        if (this.objectToInsert == null) {
            this.objectToInsert = new CopyOnWriteArrayList<Object>();
        }
        if (this.objectToInsert.size() >= 50) {
            this.insertList(result);
            this.objectToInsert.clear();
            this.objectToInsert.add(obj);
        } else {
            result.setResult(BatchResult.Result.WAITING, null);
            this.objectToInsert.add(obj);
        }
        if (end) {
            this.insertList(result);
            this.objectToInsert = null;
        }
        return result;
    }

    private void insertList(BatchResult result) {
        Transaction tx = null;
        try (Session session = this.sessionFactory.openSession();){
            try {
                tx = session.beginTransaction();
                for (Object objToInsert : this.objectToInsert) {
                    session.save(objToInsert);
                }
                session.flush();
                session.clear();
                tx.commit();
                result.addFilesTraited(this.objectToInsert.size());
                result.setResult(BatchResult.Result.INSERTION, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                tx.rollback();
                result.addFilesTraited(this.objectToInsert.size());
                result.setResult(BatchResult.Result.ERROR, e.getMessage());
                session.close();
            }
        }
    }

    public void update(Object obj) {
        Session session = this.getCurrentSession();
        try {
            Object res = session.merge(obj);
            session.update(res);
            session.flush();
            session.clear();
            session.close();
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public Session getCurrentSession() {
        Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        return session;
    }

    public <T> T get(Class<T> clazz, Integer id) {
        Session session = this.getCurrentSession();
        try {
            Object result = session.get(clazz, (Serializable)id);
            session.flush();
            session.clear();
            session.close();
            return (T)result;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> loadAll(Class<T> clazz) {
        Session session = this.getCurrentSession();
        try {
            List res = session.createCriteria(clazz).list();
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public List find(String query) {
        Session session = this.getCurrentSession();
        try {
            Query hq = session.createQuery(query);
            List res = hq.list();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public Object findOne(String query) {
        Session session = this.getCurrentSession();
        try {
            Query hq = session.createQuery(query);
            List res = hq.list();
            session.close();
            if (res != null && res.size() > 0) {
                return res.get(0);
            }
            return null;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public long count(String query, List<Object> parameters) {
        Session session = this.getCurrentSession();
        try {
            Query hq = session.createQuery(query);
            if (parameters != null) {
                int i = 0;
                for (Object param : parameters) {
                    hq.setParameter(i, param);
                    ++i;
                }
            }
            long rowCount = (Long)hq.uniqueResult();
            session.close();
            return rowCount;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> find(String query, int firstResult, int maxResult) {
        Session session = this.getCurrentSession();
        try {
            Query hq = session.createQuery(query);
            hq.setFirstResult(firstResult).setMaxResults(maxResult);
            List res = hq.list();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> find(String query, Object ... parameters) {
        Session session = this.getCurrentSession();
        try {
            Query hq = session.createQuery(query);
            if (parameters != null) {
                int i = 0;
                Object[] objectArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Object param = objectArray[n2];
                    hq.setParameter(i, param);
                    ++i;
                    ++n2;
                }
            }
            List res = hq.list();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> findWithPag(String query, int firstResult, int maxResult, List<Object> parameters) {
        Session session = this.getCurrentSession();
        try {
            Query hq = session.createQuery(query);
            hq.setFirstResult(firstResult).setMaxResults(maxResult);
            if (parameters != null) {
                int i = 0;
                for (Object param : parameters) {
                    hq.setParameter(i, param);
                    ++i;
                }
            }
            List res = hq.list();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> find(String query, List<Object> args) {
        Session session = this.getCurrentSession();
        try {
            Query q = session.createQuery(query);
            int i = 0;
            while (i < args.size()) {
                q.setParameter(i, args.get(i));
                ++i;
            }
            List res = q.list();
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public List find(String query, int limit) {
        Session session = this.getCurrentSession();
        try {
            Query q = session.createQuery(query);
            q.setMaxResults(limit);
            List res = q.list();
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> findByCriteria(DetachedCriteria criteria) {
        Session session = this.getCurrentSession();
        try {
            List res = criteria.getExecutableCriteria(session).list();
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> List<T> findByCriteria(DetachedCriteria criteria, int firstResult, int maxResults) {
        Session session = this.getCurrentSession();
        try {
            List res = criteria.getExecutableCriteria(session).setFirstResult(firstResult).setMaxResults(maxResults).list();
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public List saveOrUpdateAll(List beans) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object o : beans) {
            Object res = this.saveOrUpdate(o);
            newList.add(res);
        }
        return newList;
    }

    public void flush() {
        Session session = this.getCurrentSession();
        try {
            session.flush();
            session.clear();
            session.close();
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public Object load(Class class1, Long long1) {
        Session session = this.getCurrentSession();
        try {
            Object res = session.load(class1, (Serializable)long1);
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public List findBySqlQuery(String sql, Class cl) {
        Session session = this.getCurrentSession();
        try {
            SQLQuery query = session.createSQLQuery(sql);
            query.addEntity(cl);
            List res = query.list();
            session.flush();
            session.clear();
            session.close();
            return res;
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public void stop() {
        this.sessionFactory.close();
    }

    public void evict(Object item) {
        Session session = this.getCurrentSession();
        try {
            session.evict(item);
            session.clear();
            session.close();
        }
        catch (Exception e) {
            session.clear();
            session.close();
            throw e;
        }
    }

    public <T> boolean isProxy(T entity) {
        if (entity == null) {
            throw new NullPointerException("Entity passed for initialization is null");
        }
        return entity instanceof HibernateProxy;
    }
}

