/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.jdbc.management.model;

import bpm.studio.jdbc.management.model.DigesterDBXML;
import bpm.studio.jdbc.management.model.DriverInfo;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ListDriver {
    public static final String MS_ACCESS = "MSAccess Database";
    public static final String MS_XLS = "XLS Database";
    private HashMap<String, DriverInfo> drivers = new HashMap();
    private static ListDriver instance = null;
    private String jdbcXmlFilePath;

    public static ListDriver getInstance(String jdbcXmlFilePath) throws Exception {
        if (instance == null) {
            instance = new ListDriver(jdbcXmlFilePath);
        }
        return instance;
    }

    private ListDriver(String jdbcXmlFilePath) throws Exception {
        String jarPath = null;
        int p = jdbcXmlFilePath.lastIndexOf("/");
        jarPath = jdbcXmlFilePath.substring(p + 1).contains("\\") ? jdbcXmlFilePath.substring(0, jdbcXmlFilePath.lastIndexOf("\\")) : jdbcXmlFilePath.substring(0, p);
        try {
            DigesterDBXML dig = new DigesterDBXML(jdbcXmlFilePath, String.valueOf(jarPath) + "/jdbc/");
            for (DriverInfo d : dig.getListDriver()) {
                this.addDriver(d, false);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.jdbcXmlFilePath = jdbcXmlFilePath;
    }

    public void addDriver(DriverInfo d, boolean save) throws Exception {
        this.drivers.put(d.getName(), d);
        if (save) {
            this.save(this.jdbcXmlFilePath);
        }
    }

    private void save(String path) throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("drivers");
        for (DriverInfo i : this.drivers.values()) {
            Element e = root.addElement("driver");
            e.addAttribute("name", i.getName()).addAttribute("className", i.getClassName()).addAttribute("file", i.getFile()).addAttribute("prefix", i.getUrlPrefix());
        }
        try {
            XMLWriter w = new XMLWriter((OutputStream)new FileOutputStream(path), OutputFormat.createPrettyPrint());
            w.write(doc);
            w.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Error when saving driverjdbc.xml file : " + ex.getMessage(), ex);
        }
    }

    public DriverInfo getInfo(String key) {
        return this.drivers.get(key);
    }

    public Collection<String> getDriversName() {
        return this.drivers.keySet();
    }

    public Collection<DriverInfo> getDriversInfo() {
        return this.drivers.values();
    }

    public void removeDriver(DriverInfo info) throws Exception {
        for (String key : this.drivers.keySet()) {
            if (this.drivers.get(key) != info) continue;
            this.drivers.remove(key);
            break;
        }
        this.save(this.jdbcXmlFilePath);
    }
}

