/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.jdbc.management.config;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class IConstants {
    private static String driverFile = null;
    private static String jdbcJarFolder = null;
    private static String resourcesFolder = null;
    private static Properties vanillaConfig;

    private static void loadVanillaConfig() {
        if (vanillaConfig == null) {
            vanillaConfig = new Properties();
            String p = System.getProperty("bpm.vanilla.configurationFile");
            if (p != null && !p.equals("")) {
                Logger.getLogger((String)"bpm.studio.jdbc.management").info((Object)("reading Vanilla Config Properties from " + p));
                try {
                    vanillaConfig.load(new FileInputStream(p));
                }
                catch (Exception ex) {
                    Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)("unable to read Vanilla Config Properties from " + p + " - " + ex.getMessage()), (Throwable)ex);
                }
            } else {
                Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)"The system property bpm.vanilla.configurationFile has not been set, the default configuration will be used ");
            }
        }
    }

    public static String getJdbcDriverXmlFile() {
        if (driverFile == null) {
            Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)"JdbcDriverXmlFile not defined...");
            IConstants.loadVanillaConfig();
            driverFile = vanillaConfig.getProperty("bpm.vanilla.platform.jdbcDriverXmlFile");
            Logger.getLogger((String)"bpm.studio.jdbc.management").info((Object)("JdbcDriverFile set with " + driverFile));
            if (driverFile == null) {
                driverFile = "resources/driverjdbc.xml";
                Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)("JdbcDriverXmlFile not find from vanillaConfiguration properties - inited at " + driverFile));
            }
        }
        return driverFile;
    }

    public static String getResourcesFolder() {
        if (resourcesFolder == null) {
            Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)"ResourceFolder not defined...");
            IConstants.loadVanillaConfig();
            resourcesFolder = vanillaConfig.getProperty("bpm.vanilla.platform.resourcesFolder");
            Logger.getLogger((String)"bpm.studio.jdbc.management").info((Object)("ResourcesFolder set with " + resourcesFolder));
            if (resourcesFolder == null) {
                resourcesFolder = "resources";
                Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)("ResourcesFolder not find from vanillaConfiguration properties - inited at " + resourcesFolder));
            }
        }
        return resourcesFolder;
    }

    public static String getJdbcJarFolder() {
        if (jdbcJarFolder == null) {
            Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)"JdbcJarFolder not defined...");
            IConstants.loadVanillaConfig();
            jdbcJarFolder = vanillaConfig.getProperty("bpm.vanilla.platform.jdbcDriverFolder");
            Logger.getLogger((String)"bpm.studio.jdbc.management").info((Object)("JdbcJarFolder set with " + jdbcJarFolder));
            if (jdbcJarFolder == null) {
                jdbcJarFolder = "resources/jdbc";
                Logger.getLogger((String)"bpm.studio.jdbc.management").warn((Object)("JdbcJarFolder not find from vanillaConfiguration properties - inited at " + jdbcJarFolder));
            }
        }
        return jdbcJarFolder;
    }
}

