/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.map.oda.ui.dataset;

import bpm.vanilla.map.core.design.fusionmap.IFusionMapObject;
import bpm.vanilla.map.core.design.fusionmap.IFusionMapSpecificationEntity;
import bpm.vanilla.map.remote.core.design.impl.RemoteFusionMapRegistry;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FusionMapDataSetPage
extends DataSetWizardPage {
    private ComboViewer fusionMaps;
    private Text description;
    private TableViewer datas;

    public FusionMapDataSetPage(String pageName) {
        super(pageName);
    }

    public FusionMapDataSetPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 1, true, false));
        main.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Select A FusionMap");
        this.fusionMaps = new ComboViewer(main, 8);
        this.fusionMaps.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fusionMaps.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IFusionMapObject)element).getName();
            }
        });
        this.fusionMaps.getCombo().setLayoutData((Object)new GridData(4, 2, true, false));
        this.fusionMaps.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)FusionMapDataSetPage.this.fusionMaps.getSelection()).getFirstElement();
                FusionMapDataSetPage.this.description.setText(((IFusionMapObject)o).getDescription());
                FusionMapDataSetPage.this.datas.setInput((Object)((IFusionMapObject)o).getSpecificationsEntities());
                try {
                    if (FusionMapDataSetPage.this.getContainer() != null) {
                        FusionMapDataSetPage.this.getContainer().updateButtons();
                    }
                }
                catch (Exception exception) {}
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 4, false, true));
        l.setText("Description");
        this.description = new Text(main, 2048);
        this.description.setLayoutData((Object)new GridData(4, 4, true, true));
        this.datas = new TableViewer(main, 2816);
        this.datas.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.datas.getTable().setHeaderVisible(true);
        this.datas.getTable().setLinesVisible(true);
        this.datas.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableViewerColumn col = new TableViewerColumn(this.datas, 16384);
        col.getColumn().setWidth(100);
        col.getColumn().setText("Internal Id");
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IFusionMapSpecificationEntity)element).getFusionMapInternalId();
            }
        });
        col = new TableViewerColumn(this.datas, 16384);
        col.getColumn().setWidth(100);
        col.getColumn().setText("Short Name");
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IFusionMapSpecificationEntity)element).getFusionMapShortName();
            }
        });
        col = new TableViewerColumn(this.datas, 16384);
        col.getColumn().setWidth(100);
        col.getColumn().setText("Short Name");
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IFusionMapSpecificationEntity)element).getFusionMapLongName();
            }
        });
        this.setControl((Control)main);
        this.initialiseControl();
    }

    public boolean isPageComplete() {
        return !this.fusionMaps.getSelection().isEmpty();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign dataSetDesign) {
        if (this.fusionMaps != null) {
            String queryText = "" + ((IFusionMapObject)((IStructuredSelection)this.fusionMaps.getSelection()).getFirstElement()).getId();
            dataSetDesign.setQueryText(queryText);
        }
        if (dataSetDesign.getPublicProperties() == null) {
            try {
                dataSetDesign.setPublicProperties(DesignSessionUtil.createDataSetPublicProperties((String)dataSetDesign.getOdaExtensionDataSourceId(), (String)dataSetDesign.getOdaExtensionDataSetId(), (Properties)FusionMapDataSetPage.getBlankPageProperties()));
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        return dataSetDesign;
    }

    private static Properties getBlankPageProperties() {
        Properties prop = new Properties();
        prop.setProperty("bpm.vanilla.map.oda.runtime.vanillaRuntimeServerUrl", "");
        return prop;
    }

    private void initialiseControl() {
        RemoteFusionMapRegistry fusionMapRegistry = null;
        Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        String vanillaServerUrl = null;
        try {
            vanillaServerUrl = connProps.getProperty("bpm.vanilla.map.oda.runtime.vanillaRuntimeServerUrl");
            fusionMapRegistry = new RemoteFusionMapRegistry();
            fusionMapRegistry.configure((Object)vanillaServerUrl);
            this.fusionMaps.setInput((Object)fusionMapRegistry.getFusionMapObjects());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Unable to load available FusionMapsObject from Vanilla Platform at " + vanillaServerUrl + ".\n" + ex.getMessage()));
        }
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
            return;
        }
        try {
            Long l = Long.parseLong(dataSetDesign.getQueryText());
            for (Object o : (List)this.fusionMaps.getInput()) {
                if (((IFusionMapObject)o).getId() != l.longValue()) continue;
                this.fusionMaps.setSelection((ISelection)new StructuredSelection(o));
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The query could not been rebuilt.\n" + ex.getMessage()));
        }
    }
}

