/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.wizards.page;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.utils.MD5Helper;
import bpm.vanilla.repository.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositorySelectionPage
extends WizardPage {
    private ComboViewer repository;
    private ComboViewer groups;
    private Text repositoryPassword;
    private Text repositoryLogin;
    private Text vanillaUrl;
    private IVanillaAPI aa;
    private User user;

    public RepositorySelectionPage(String pageName) {
        super(pageName);
        this.setDescription(Messages.RepositorySelectionPage_0);
    }

    public void createControl(Composite parent) {
        Composite connCmp = new Composite(parent, 0);
        connCmp.setLayout((Layout)new GridLayout(3, false));
        connCmp.setLayoutData((Object)new GridData(1808));
        Label l0 = new Label(connCmp, 0);
        l0.setLayoutData((Object)new GridData(1, 2, false, false));
        l0.setText(Messages.RepositorySelectionPage_1);
        Label l = new Label(connCmp, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.RepositorySelectionPage_2);
        this.vanillaUrl = new Text(connCmp, 2048);
        this.vanillaUrl.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.vanillaUrl.setText("http://localhost:8080/vanilla");
        l = new Label(connCmp, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.RepositorySelectionPage_4);
        this.repositoryLogin = new Text(connCmp, 2048);
        this.repositoryLogin.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.repositoryLogin.setText("system");
        this.repositoryLogin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.getContainer().updateButtons();
            }
        });
        l = new Label(connCmp, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.RepositorySelectionPage_6);
        this.repositoryPassword = new Text(connCmp, 0x400800);
        this.repositoryPassword.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.repositoryPassword.setText("system");
        this.repositoryPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.getContainer().updateButtons();
            }
        });
        Button b = new Button(connCmp, 8);
        b.setText(Messages.RepositorySelectionPage_8);
        b.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RepositorySelectionPage.this.aa = (IVanillaAPI)new RemoteVanillaPlatform(RepositorySelectionPage.this.vanillaUrl.getText(), RepositorySelectionPage.this.repositoryLogin.getText(), RepositorySelectionPage.this.repositoryPassword.getText());
                    RepositorySelectionPage.this.user = RepositorySelectionPage.this.aa.getVanillaSecurityManager().getUserByLogin(RepositorySelectionPage.this.repositoryLogin.getText());
                    if (RepositorySelectionPage.this.user == null) {
                        throw new Exception(Messages.RepositorySelectionPage_9);
                    }
                    if (!RepositorySelectionPage.this.user.getPassword().equals(MD5Helper.encode((String)RepositorySelectionPage.this.repositoryPassword.getText()))) {
                        throw new Exception(Messages.RepositorySelectionPage_10);
                    }
                    RepositorySelectionPage.this.repository.setInput((Object)RepositorySelectionPage.this.aa.getVanillaRepositoryManager().getRepositories());
                    RepositorySelectionPage.this.groups.setInput((Object)RepositorySelectionPage.this.aa.getVanillaSecurityManager().getGroups(RepositorySelectionPage.this.user));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    RepositorySelectionPage.this.repository.setInput(new ArrayList());
                    RepositorySelectionPage.this.groups.setInput(new ArrayList());
                    MessageDialog.openError((Shell)RepositorySelectionPage.this.getShell(), (String)Messages.RepositorySelectionPage_11, (String)(String.valueOf(Messages.RepositorySelectionPage_12) + e1.getMessage()));
                }
            }
        });
        l = new Label(connCmp, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.RepositorySelectionPage_13);
        this.groups = new ComboViewer(connCmp, 8);
        this.groups.getCombo().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.groups.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        this.groups.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        this.groups.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositorySelectionPage.this.getContainer().updateButtons();
            }
        });
        l = new Label(connCmp, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.RepositorySelectionPage_14);
        this.repository = new ComboViewer(connCmp, 8);
        this.repository.getCombo().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.repository.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        this.repository.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Repository)element).getName();
            }
        });
        this.repository.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositorySelectionPage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)connCmp);
    }

    public IRepositoryApi getRepositoryConnection() {
        Group group = (Group)((IStructuredSelection)this.groups.getSelection()).getFirstElement();
        Repository repDef = (Repository)((IStructuredSelection)this.repository.getSelection()).getFirstElement();
        RemoteRepositoryApi sock = new RemoteRepositoryApi((IRepositoryContext)new BaseRepositoryContext((IVanillaContext)new BaseVanillaContext(repDef.getUrl(), this.repositoryLogin.getText(), this.repositoryPassword.getText()), group, repDef));
        return sock;
    }

    public boolean isPageComplete() {
        return !this.repository.getSelection().isEmpty() && !this.groups.getSelection().isEmpty();
    }

    public IRepositoryContext getRepositoryContext() {
        Group group = (Group)((IStructuredSelection)this.groups.getSelection()).getFirstElement();
        Repository repDef = (Repository)((IStructuredSelection)this.repository.getSelection()).getFirstElement();
        BaseVanillaContext vCtx = new BaseVanillaContext(this.vanillaUrl.getText(), this.repositoryLogin.getText(), this.repositoryPassword.getText());
        BaseRepositoryContext ctx = new BaseRepositoryContext((IVanillaContext)vCtx, group, repDef);
        return ctx;
    }
}

