/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.wizards.page;

import bpm.repository.ui.SessionSourceProvider;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.IVanillaSecurityManager;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.repository.RepositoryDirectory;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.platform.core.repository.SecuredCommentObject;
import bpm.vanilla.platform.core.utils.IOWriter;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.dialogs.DialogNewDirectory;
import bpm.vanilla.repository.ui.dialogs.DialogNewItem;
import bpm.vanilla.repository.ui.dialogs.DialogShowDependencies;
import bpm.vanilla.repository.ui.versionning.VersionningManager;
import bpm.vanilla.repository.ui.viewers.RepositoryViewerFilter;
import bpm.vanilla.repository.ui.wizards.page.ExportObjectWizard;
import bpm.vanilla.repository.ui.wizards.page.RepositoryContentBasePage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.services.ISourceProviderService;

public class RepositoryExportPage
extends RepositoryContentBasePage {
    public static final int UPDATE_BUTTON_ID = 1;
    public static final int CHECKOUT_BUTTON_ID = 2;
    public static final int SHARE_BUTTON_ID = 3;
    protected ToolItem newObject;
    protected ToolItem delete;
    protected ToolItem newDirectory;
    protected ToolItem update;
    protected ToolItem loadModel;
    protected ToolItem checkout;
    protected ToolItem share;
    protected ToolItem showDep;
    protected ExportObjectWizard wizard;

    public RepositoryExportPage(String pageName) {
        super(pageName);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        if (Activator.getDefault().getDesignerActivator() != null && Activator.getDefault().getDesignerActivator().getRepositoryConnection() != null) {
            try {
                this.compositeRepository.addViewerFilter(new RepositoryViewerFilter(new int[]{Activator.getDefault().getDesignerActivator().getRepositoryItemType()}, new int[0]));
                this.fillContent(Activator.getDefault().getDesignerActivator().getRepositoryContext(), Activator.getDefault().getDesignerActivator().getRepositoryConnection());
                ((ExportObjectWizard)this.getWizard()).setRepositoryConnection(Activator.getDefault().getDesignerActivator().getRepositoryConnection());
                IRepositoryContext ctx = Activator.getDefault().getDesignerActivator().getRepositoryContext();
                BaseVanillaContext vanillaCtx = new BaseVanillaContext(ctx.getVanillaContext().getVanillaUrl(), ctx.getVanillaContext().getLogin(), ctx.getVanillaContext().getPassword());
                ((ExportObjectWizard)this.getWizard()).setVanillaApi((IVanillaAPI)new RemoteVanillaPlatform((IVanillaContext)vanillaCtx));
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.RepositoryExportPage_0, (String)(String.valueOf(Messages.RepositoryExportPage_1) + e.getMessage()));
            }
        }
    }

    protected void attachButtonsListeners() {
        this.showDep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IRepositoryApi sock = RepositoryExportPage.this.wizard.getRepositoryConnection();
                    RepositoryItem target = null;
                    if (!RepositoryExportPage.this.compositeRepository.getSelectedItems().isEmpty()) {
                        target = (RepositoryItem)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0);
                        DialogShowDependencies dial = new DialogShowDependencies(RepositoryExportPage.this.getShell(), target, sock, DialogShowDependencies.TITLE);
                        if (dial.hasDependencies()) {
                            dial.open();
                        } else {
                            MessageDialog.openInformation((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_5, (String)Messages.RepositoryExportPage_6);
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.newDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRepositoryApi sock = RepositoryExportPage.this.wizard.getRepositoryConnection();
                IVanillaSecurityManager mng = RepositoryExportPage.this.wizard.getVanillaApi().getVanillaSecurityManager();
                try {
                    DialogNewDirectory dial = new DialogNewDirectory(RepositoryExportPage.this.getShell(), mng.getGroups());
                    if (dial.open() != 0) {
                        return;
                    }
                    RepositoryDirectory target = null;
                    if (!RepositoryExportPage.this.compositeRepository.getSelectedItems().isEmpty()) {
                        target = (RepositoryDirectory)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0);
                    }
                    Properties p = dial.getProperties();
                    RepositoryDirectory newDir = sock.getRepositoryService().addDirectory(p.getProperty("name"), p.getProperty("desc"), target);
                    RepositoryExportPage.this.compositeRepository.getInput().add(newDir);
                    RepositoryExportPage.this.compositeRepository.refresh();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_2, (String)(String.valueOf(Messages.RepositoryExportPage_3) + e1.getMessage()));
                }
            }
        });
        this.newObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRepositoryApi sock = RepositoryExportPage.this.wizard.getRepositoryConnection();
                IVanillaSecurityManager mng = RepositoryExportPage.this.wizard.getVanillaApi().getVanillaSecurityManager();
                try {
                    DialogNewItem dial = new DialogNewItem(RepositoryExportPage.this.getShell(), mng.getGroups());
                    if (dial.open() != 0) {
                        return;
                    }
                    RepositoryDirectory target = (RepositoryDirectory)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0);
                    Properties p = dial.getProperties();
                    String modelXml = RepositoryExportPage.this.wizard.getDesignerActivator().getCurrentModelXml();
                    String[] groupNames = p.getProperty("group").split(";");
                    RepositoryItem newItem = sock.getRepositoryService().addDirectoryItemWithDisplay(Activator.getDefault().getDesignerActivator().getRepositoryItemType(), -1, target, p.getProperty("name"), p.getProperty("desc"), "", "", modelXml, true);
                    RepositoryExportPage.this.compositeRepository.getInput().add(newItem);
                    RepositoryExportPage.this.compositeRepository.refresh();
                    try {
                        ISourceProviderService service = (ISourceProviderService)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getService(ISourceProviderService.class);
                        SessionSourceProvider pro = (SessionSourceProvider)service.getSourceProvider("bpm.repository.ui.connected");
                        pro.setDirectoryItemId(newItem.getId());
                        RepositoryExportPage.this.wizard.getDesignerActivator().setCurrentDirectoryItemId(Integer.valueOf(newItem.getId()));
                    }
                    catch (Exception exception) {}
                    StringBuilder errorSecu = new StringBuilder();
                    String[] stringArray = groupNames;
                    int n = groupNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        try {
                            Integer groupId = null;
                            try {
                                groupId = mng.getGroupByName(s).getId();
                            }
                            catch (Exception exception) {
                                throw new Exception(String.valueOf(Messages.RepositoryExportPage_4) + s);
                            }
                            sock.getAdminService().addGroupForItem(groupId.intValue(), newItem.getId());
                            Group dummyGroup = new Group();
                            dummyGroup.setId(groupId);
                            sock.getAdminService().setObjectRunnableForGroup(dummyGroup.getId(), newItem);
                            SecuredCommentObject secComment = new SecuredCommentObject();
                            secComment.setGroupId(groupId);
                            secComment.setObjectId(Integer.valueOf(newItem.getId()));
                            secComment.setType(1);
                            sock.getDocumentationService().addSecuredCommentObject(secComment);
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                            errorSecu.append(String.valueOf(Messages.RepositoryExportPage_9) + s + " : " + ex2.getMessage() + "\n");
                        }
                        ++n2;
                    }
                    if (errorSecu.toString().length() > 0) {
                        throw new Exception(String.valueOf(Messages.RepositoryExportPage_12) + errorSecu.toString());
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_13, (String)(String.valueOf(Messages.RepositoryExportPage_14) + e1.getMessage()));
                }
                if (RepositoryExportPage.this.shouldCloseWizardOnImport() && RepositoryExportPage.this.getWizard().performFinish()) {
                    RepositoryExportPage.this.getContainer().getShell().close();
                }
            }
        });
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRepositoryApi sock = RepositoryExportPage.this.wizard.getRepositoryConnection();
                Object target = RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0);
                if (target instanceof RepositoryDirectory) {
                    try {
                        sock.getRepositoryService().delete((RepositoryDirectory)target);
                        RepositoryExportPage.this.compositeRepository.getInput().remove((RepositoryDirectory)target);
                        RepositoryExportPage.this.compositeRepository.refresh();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_15, (String)(String.valueOf(Messages.RepositoryExportPage_16) + e1.getMessage()));
                    }
                } else if (target instanceof RepositoryItem) {
                    try {
                        DialogShowDependencies dial = new DialogShowDependencies(RepositoryExportPage.this.getShell(), (RepositoryItem)target, sock, DialogShowDependencies.DELETE_TITLE);
                        if (dial.hasDependencies() && dial.open() != 0) {
                            return;
                        }
                        sock.getRepositoryService().delete((RepositoryItem)target);
                        RepositoryExportPage.this.compositeRepository.getInput().remove((RepositoryItem)target);
                        RepositoryExportPage.this.compositeRepository.refresh();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_17, (String)(String.valueOf(Messages.RepositoryExportPage_18) + e1.getMessage()));
                    }
                }
            }
        });
        this.update.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRepositoryApi sock = Activator.getDefault().getDesignerActivator().getRepositoryConnection();
                try {
                    DialogShowDependencies dial = new DialogShowDependencies(RepositoryExportPage.this.getShell(), (RepositoryItem)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0), sock, DialogShowDependencies.UPDATE_TITLE);
                    if (dial.hasDependencies() && dial.open() != 0) {
                        return;
                    }
                    sock.getRepositoryService().updateModel((RepositoryItem)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0), Activator.getDefault().getDesignerActivator().getCurrentModelXml());
                    MessageDialog.openInformation((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_19, (String)Messages.RepositoryExportPage_20);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openInformation((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_21, (String)(String.valueOf(Messages.RepositoryExportPage_22) + e1.getMessage()));
                }
                if (RepositoryExportPage.this.shouldCloseWizardOnImport() && RepositoryExportPage.this.getWizard().performFinish()) {
                    RepositoryExportPage.this.getContainer().getShell().close();
                }
            }
        });
        this.loadModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String modelXml = null;
                try {
                    modelXml = RepositoryExportPage.this.wizard.getRepositoryConnection().getRepositoryService().loadModel((RepositoryItem)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_23, (String)(String.valueOf(Messages.RepositoryExportPage_24) + ex.getMessage()));
                    return;
                }
                try {
                    RepositoryExportPage.this.wizard.getDesignerActivator().setCurrentModel(modelXml, Integer.valueOf(((RepositoryItem)RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0)).getId()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_25, (String)(String.valueOf(Messages.RepositoryExportPage_26) + ex.getMessage()));
                }
                if (RepositoryExportPage.this.shouldCloseWizardOnImport() && RepositoryExportPage.this.getWizard().performFinish()) {
                    RepositoryExportPage.this.getContainer().getShell().close();
                }
            }
        });
        this.share.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0);
                if (o instanceof RepositoryItem) {
                    IRepositoryApi sock = RepositoryExportPage.this.wizard.getRepositoryConnection();
                    try {
                        sock.getVersioningService().share((RepositoryItem)o);
                        MessageDialog.openInformation((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_27, (String)Messages.RepositoryExportPage_28);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_29, (String)(String.valueOf(Messages.RepositoryExportPage_30) + ex.getMessage()));
                    }
                }
            }
        });
        this.checkout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = RepositoryExportPage.this.compositeRepository.getSelectedItems().get(0);
                if (o instanceof RepositoryItem) {
                    IRepositoryApi sock = RepositoryExportPage.this.wizard.getRepositoryConnection();
                    String xml = null;
                    try {
                        InputStream is = sock.getVersioningService().checkOut((RepositoryItem)o);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        IOWriter.write((InputStream)is, (OutputStream)bos, (boolean)true, (boolean)true);
                        xml = bos.toString("UTF-8");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_31, (String)(String.valueOf(Messages.RepositoryExportPage_32) + ex.getMessage()));
                        return;
                    }
                    Object oldModel = Activator.getDefault().getDesignerActivator().getCurrentModel();
                    try {
                        Activator.getDefault().getDesignerActivator().setCurrentModel(xml, Integer.valueOf(((RepositoryItem)o).getId()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_33, (String)(String.valueOf(Messages.RepositoryExportPage_34) + ex.getMessage()));
                        return;
                    }
                    Object saveResult = null;
                    try {
                        saveResult = Activator.getDefault().getDesignerActivator().saveCurrentModel();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_35, (String)(String.valueOf(Messages.RepositoryExportPage_36) + ex.getMessage()));
                        return;
                    }
                    if (saveResult == null) {
                        Activator.getDefault().getDesignerActivator().setCurrentModel(oldModel);
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_37, (String)Messages.RepositoryExportPage_38);
                        return;
                    }
                    if (saveResult instanceof File) {
                        VersionningManager.getInstance().saveChekout(((File)saveResult).getAbsolutePath(), sock, (RepositoryItem)o);
                    } else {
                        MessageDialog.openError((Shell)RepositoryExportPage.this.getShell(), (String)Messages.RepositoryExportPage_39, (String)Messages.RepositoryExportPage_40);
                    }
                }
            }
        });
        this.compositeRepository.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (RepositoryExportPage.this.loadModel.getEnabled()) {
                    RepositoryExportPage.this.loadModel.notifyListeners(13, new Event());
                }
            }
        });
    }

    @Override
    protected void fillToolbar(ToolBar bar) {
        this.newDirectory = new ToolItem(bar, 0);
        this.newDirectory.setText(Messages.RepositoryExportPage_41);
        this.newDirectory.setToolTipText(Messages.RepositoryExportPage_42);
        this.newDirectory.setImage(Activator.getDefault().getImageRegistry().get("folder.png"));
        this.newObject = new ToolItem(bar, 0);
        this.newObject.setText(Messages.RepositoryExportPage_43);
        this.newObject.setToolTipText(Messages.RepositoryExportPage_44);
        this.newObject.setImage(Activator.getDefault().getImageRegistry().get("add.png"));
        this.delete = new ToolItem(bar, 0);
        this.delete.setText(Messages.RepositoryExportPage_45);
        this.delete.setToolTipText(Messages.RepositoryExportPage_46);
        this.delete.setImage(Activator.getDefault().getImageRegistry().get("del.png"));
        this.update = new ToolItem(bar, 0);
        this.update.setText(Messages.RepositoryExportPage_47);
        this.update.setImage(Activator.getDefault().getImageRegistry().get("refresh.png"));
        this.update.setToolTipText(Messages.RepositoryExportPage_48);
        this.update.setEnabled(false);
        this.loadModel = new ToolItem(bar, 0);
        this.loadModel.setText(Messages.RepositoryExportPage_49);
        this.loadModel.setToolTipText(Messages.RepositoryExportPage_50);
        this.loadModel.setEnabled(false);
        this.loadModel.setImage(Activator.getDefault().getImageRegistry().get("import.png"));
        this.share = new ToolItem(bar, 0);
        this.share.setText(Messages.RepositoryExportPage_51);
        this.share.setToolTipText(Messages.RepositoryExportPage_52);
        this.share.setEnabled(false);
        this.share.setImage(Activator.getDefault().getImageRegistry().get("share.png"));
        this.checkout = new ToolItem(bar, 0);
        this.checkout.setText(Messages.RepositoryExportPage_53);
        this.checkout.setToolTipText(Messages.RepositoryExportPage_54);
        this.checkout.setEnabled(false);
        this.checkout.setImage(Activator.getDefault().getImageRegistry().get("checkout.png"));
        this.showDep = new ToolItem(bar, 0);
        this.showDep.setText(Messages.RepositoryExportPage_8);
        this.showDep.setToolTipText(Messages.RepositoryExportPage_10);
        this.showDep.setEnabled(false);
        this.showDep.setImage(Activator.getDefault().getImageRegistry().get("dependencies.png"));
        this.compositeRepository.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (o instanceof RepositoryItem) {
                    RepositoryExportPage.this.loadModel.setEnabled(true);
                    if (RepositoryExportPage.this.wizard.getDesignerActivator().getCurrentModelDirectoryItemId() == null || RepositoryExportPage.this.wizard.getDesignerActivator().getCurrentModelDirectoryItemId() <= 0) {
                        RepositoryExportPage.this.update.setEnabled(false);
                    } else if (((RepositoryItem)o).getId() == RepositoryExportPage.this.wizard.getDesignerActivator().getCurrentModelDirectoryItemId().intValue()) {
                        RepositoryExportPage.this.update.setEnabled(true);
                    } else {
                        RepositoryExportPage.this.update.setEnabled(false);
                    }
                    RepositoryExportPage.this.share.setEnabled(true);
                    RepositoryExportPage.this.checkout.setEnabled(true);
                    RepositoryExportPage.this.showDep.setEnabled(true);
                } else {
                    RepositoryExportPage.this.update.setEnabled(false);
                    RepositoryExportPage.this.loadModel.setEnabled(false);
                    RepositoryExportPage.this.share.setEnabled(false);
                    RepositoryExportPage.this.checkout.setEnabled(false);
                    RepositoryExportPage.this.showDep.setEnabled(false);
                }
                RepositoryExportPage.this.newObject.setEnabled(o instanceof RepositoryDirectory && Activator.getDefault().getDesignerActivator().getCurrentModel() != null);
            }
        });
        this.attachButtonsListeners();
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        if (newWizard instanceof ExportObjectWizard) {
            this.wizard = (ExportObjectWizard)newWizard;
        }
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }
}

