/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.wizards.page;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.repository.Repository;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.composites.CompositeRepositoryItemSelecter;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class RepositoryContentBasePage
extends WizardPage {
    protected CompositeRepositoryItemSelecter compositeRepository;
    private Button closeOnImport;

    public RepositoryContentBasePage(String pageName) {
        super(pageName);
    }

    protected boolean shouldCloseWizardOnImport() {
        if (this.closeOnImport != null && !this.closeOnImport.isDisposed()) {
            return this.closeOnImport.getSelection();
        }
        return false;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(1808));
        ToolBar bar = new ToolBar(main, 0);
        bar.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.compositeRepository = new CompositeRepositoryItemSelecter(main, 2048);
        this.compositeRepository.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.compositeRepository.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoryContentBasePage.this.getContainer().updateButtons();
            }
        });
        this.closeOnImport = new Button(main, 32);
        this.closeOnImport.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.closeOnImport.setText(Messages.RepositoryContentBasePage_2);
        this.closeOnImport.setSelection(true);
        this.setControl((Control)main);
        this.fillToolbar(bar);
    }

    protected void fillToolbar(ToolBar bar) {
    }

    public void fillContent(IRepositoryContext ctx, IRepositoryApi sock) {
        try {
            if (Activator.getDefault().getDesignerActivator() != null) {
                Activator.getDefault().getDesignerActivator().setRepositoryContext(ctx);
            }
            this.compositeRepository.setInput(new Repository(sock, Activator.getDefault().getDesignerActivator().getRepositoryItemType()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.compositeRepository.setInput(new Repository(sock));
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.RepositoryContentBasePage_0, (String)(String.valueOf(Messages.RepositoryContentBasePage_1) + ex.getMessage()));
        }
    }

    public boolean isPageComplete() {
        return !this.compositeRepository.getSelectedItems().isEmpty() && this.compositeRepository.getSelectedItems().get(0) instanceof RepositoryItem;
    }

    public List<Object> getSelectedObjects() {
        return this.compositeRepository.getSelectedItems();
    }
}

