/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.wizards.page;

import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.viewers.RepositoryLabelProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PageConnectionDefinition
extends WizardPage {
    private ComboViewer repositories;
    private ComboViewer groups;
    private BaseVanillaContext vanillaCtx;
    private Text host;
    private Text login;
    private Text password;
    private IStatus status;
    private IRepositoryContext ctx;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
        }
    };
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PageConnectionDefinition.this.getContainer().updateButtons();
        }
    };

    public PageConnectionDefinition(String pageName) {
        super(pageName);
        this.status = Status.OK_STATUS;
    }

    public IRepositoryContext getRepositoryContext() {
        this.ctx = new BaseRepositoryContext((IVanillaContext)this.vanillaCtx, (Group)((IStructuredSelection)this.groups.getSelection()).getFirstElement(), (Repository)((IStructuredSelection)this.repositories.getSelection()).getFirstElement());
        IPreferenceStore s = bpm.vanilla.designer.ui.common.Activator.getDefault().getPreferenceStore();
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaLogin", this.login.getText());
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaUrl", this.host.getText());
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaPassword", this.password.getText());
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaGroupId", this.ctx.getGroup().getId().intValue());
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaRepositoryId", this.ctx.getRepository().getId());
        return this.ctx;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new FillLayout());
        mainComposite.setLayoutData((Object)new GridData(1808));
        this.createPageContent(mainComposite);
        this.setControl((Control)mainComposite);
        this.setPageComplete(false);
    }

    public void createPageContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label l3 = new Label(container, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText(Messages.PageConnectionDefinition_0);
        this.host = new Text(container, 2048);
        this.host.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l6 = new Label(container, 0);
        l6.setLayoutData((Object)new GridData(1, 2, false, false));
        l6.setText(Messages.PageConnectionDefinition_1);
        this.login = new Text(container, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText(Messages.PageConnectionDefinition_2);
        this.password = new Text(container, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false));
        Button loadGroups = new Button(container, 8);
        loadGroups.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        loadGroups.setText(Messages.PageConnectionDefinition_3);
        loadGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageConnectionDefinition.this.vanillaCtx = new BaseVanillaContext(PageConnectionDefinition.this.host.getText(), PageConnectionDefinition.this.login.getText(), PageConnectionDefinition.this.password.getText());
                RemoteVanillaPlatform vanillaApi = new RemoteVanillaPlatform((IVanillaContext)PageConnectionDefinition.this.vanillaCtx);
                try {
                    User user = vanillaApi.getVanillaSecurityManager().authentify("", PageConnectionDefinition.this.vanillaCtx.getLogin(), PageConnectionDefinition.this.vanillaCtx.getPassword(), false);
                    PageConnectionDefinition.this.repositories.setInput((Object)vanillaApi.getVanillaRepositoryManager().getUserRepositories(PageConnectionDefinition.this.login.getText()));
                    PageConnectionDefinition.this.groups.setInput((Object)vanillaApi.getVanillaSecurityManager().getGroups(user));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    PageConnectionDefinition.this.groups.setInput((Object)Collections.EMPTY_LIST);
                    PageConnectionDefinition.this.repositories.setInput((Object)Collections.EMPTY_LIST);
                    PageConnectionDefinition.this.vanillaCtx = null;
                    MessageDialog.openError((Shell)PageConnectionDefinition.this.getShell(), (String)Messages.PageConnectionDefinition_4, (String)(String.valueOf(Messages.PageConnectionDefinition_5) + ex.getMessage()));
                }
            }
        });
        l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText(Messages.PageConnectionDefinition_6);
        this.groups = new ComboViewer(container, 8);
        this.groups.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.groups.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        this.groups.setContentProvider((IContentProvider)new ArrayContentProvider());
        l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText(Messages.PageConnectionDefinition_7);
        this.repositories = new ComboViewer(container, 8);
        this.repositories.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.repositories.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.repositories.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fill(true);
        this.host.addModifyListener(this.modifyListener);
        this.login.addModifyListener(this.modifyListener);
        this.password.addModifyListener(this.modifyListener);
        this.groups.addSelectionChangedListener(this.selectionListener);
        this.repositories.addSelectionChangedListener(this.selectionListener);
    }

    private void connect(boolean isTimedOut) throws Exception {
        this.vanillaCtx = new BaseVanillaContext(this.host.getText(), this.login.getText(), this.password.getText());
        RemoteVanillaPlatform vanillaApi = new RemoteVanillaPlatform((IVanillaContext)this.vanillaCtx);
        User user = vanillaApi.getVanillaSecurityManager().authentify("", this.vanillaCtx.getLogin(), this.vanillaCtx.getPassword(), isTimedOut);
        this.repositories.setInput((Object)vanillaApi.getVanillaRepositoryManager().getUserRepositories(this.login.getText()));
        this.groups.setInput((Object)vanillaApi.getVanillaSecurityManager().getGroups(user));
        IPreferenceStore s = bpm.vanilla.designer.ui.common.Activator.getDefault().getPreferenceStore();
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaLogin", this.login.getText());
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaUrl", this.host.getText());
        s.setValue("bpm.vanilla.designer.ui.common.preferences.vanillaPassword", this.password.getText());
    }

    private void fill(boolean isTimedOut) {
        block12: {
            if (Activator.getDefault().getDesignerActivator() != null && Activator.getDefault().getDesignerActivator().getRepositoryContext() != null) {
                IRepositoryContext ctx = Activator.getDefault().getDesignerActivator().getRepositoryContext();
                this.login.setText(ctx.getVanillaContext().getLogin());
                this.password.setText(ctx.getVanillaContext().getPassword());
                this.host.setText(ctx.getVanillaContext().getVanillaUrl());
                try {
                    this.connect(isTimedOut);
                    if (this.groups.getInput() != null) {
                        for (Group g : (List)this.groups.getInput()) {
                            if (g.getId() != ctx.getGroup().getId()) continue;
                            this.groups.setSelection((ISelection)new StructuredSelection((Object)g));
                            break;
                        }
                    }
                    if (this.repositories.getInput() == null) break block12;
                    for (Group g : (List)this.repositories.getInput()) {
                        if (g.getId() != ctx.getRepository().getId()) continue;
                        this.repositories.setSelection((ISelection)new StructuredSelection((Object)g));
                        break;
                    }
                }
                catch (Exception exception) {}
            } else {
                IPreferenceStore s = bpm.vanilla.designer.ui.common.Activator.getDefault().getPreferenceStore();
                this.login.setText(s.getString("bpm.vanilla.designer.ui.common.preferences.vanillaLogin"));
                this.password.setText(s.getString("bpm.vanilla.designer.ui.common.preferences.vanillaPassword"));
                this.host.setText(s.getString("bpm.vanilla.designer.ui.common.preferences.vanillaUrl"));
                try {
                    this.connect(isTimedOut);
                    if (this.groups.getInput() != null) {
                        for (Group g : (List)this.groups.getInput()) {
                            if (g.getId().intValue() != s.getInt("bpm.vanilla.designer.ui.common.preferences.vanillaGroupId")) continue;
                            this.groups.setSelection((ISelection)new StructuredSelection((Object)g));
                            break;
                        }
                    }
                    if (this.repositories.getInput() == null) break block12;
                    for (Group g : (List)this.repositories.getInput()) {
                        if (g.getId() != s.getInt("bpm.vanilla.designer.ui.common.preferences.vanillaRepositoryId")) continue;
                        this.repositories.setSelection((ISelection)new StructuredSelection((Object)g));
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isPageComplete() {
        this.status = new Status(0, "bpm.vanilla.repository.ui", 0, "", null);
        if (this.host.getText().trim().equals("")) {
            this.status = new Status(4, "bpm.vanilla.repository.ui", 0, Messages.PageConnectionDefinition_10, null);
        }
        if (this.login.getText().trim().equals("")) {
            this.status = new Status(4, "bpm.vanilla.repository.ui", 0, Messages.PageConnectionDefinition_12, null);
        }
        if (this.password.getText().trim().equals("")) {
            this.status = new Status(4, "bpm.vanilla.repository.ui", 0, Messages.PageConnectionDefinition_14, null);
        }
        if (this.groups.getSelection().isEmpty()) {
            this.status = new Status(4, "bpm.vanilla.repository.ui", 0, Messages.PageConnectionDefinition_15, null);
        }
        if (this.repositories.getSelection().isEmpty()) {
            this.status = new Status(4, "bpm.vanilla.repository.ui", 0, Messages.PageConnectionDefinition_16, null);
        }
        if (this.status.getSeverity() == 0) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(this.status.getMessage());
        return false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

