/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.wizards.page;

import bpm.vanilla.designer.ui.common.IDesignerActivator;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.wizards.page.PageConnectionDefinition;
import bpm.vanilla.repository.ui.wizards.page.RepositoryExportPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportObjectWizard
extends Wizard
implements IImportWizard {
    private PageConnectionDefinition defPage;
    protected RepositoryExportPage contentPage;
    private IRepositoryApi sock;
    private IVanillaAPI vanillaApi;
    private IDesignerActivator<?> designerActivator;

    public ExportObjectWizard(IDesignerActivator<?> designerActivator) {
        this.designerActivator = designerActivator;
    }

    public ExportObjectWizard() {
        this.designerActivator = Activator.getDefault().getDesignerActivator();
    }

    public void setDesignerActivator(IDesignerActivator<?> designer) {
        this.designerActivator = designer;
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        if (Activator.getDefault().getDesignerActivator() == null || Activator.getDefault().getDesignerActivator().getRepositoryContext() == null) {
            this.defPage = new PageConnectionDefinition(Messages.ExportObjectWizard_0);
            this.defPage.setTitle(Messages.ExportObjectWizard_1);
            this.addPage((IWizardPage)this.defPage);
        }
        this.addContentPage();
    }

    protected void addContentPage() {
        this.contentPage = new RepositoryExportPage(Messages.ExportObjectWizard_2);
        this.contentPage.setTitle(Messages.ExportObjectWizard_3);
        this.addPage((IWizardPage)this.contentPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage p = super.getNextPage(page);
        IRepositoryContext ctx = null;
        if (this.defPage != null) {
            ctx = this.defPage.getRepositoryContext();
            this.designerActivator.setRepositoryContext(ctx);
            this.sock = this.designerActivator.getRepositoryConnection();
        } else {
            ctx = this.designerActivator.getRepositoryContext();
            this.sock = this.designerActivator.getRepositoryConnection();
        }
        if (p == this.contentPage) {
            try {
                this.contentPage.fillContent(ctx, this.sock);
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportObjectWizard_4, (String)(String.valueOf(Messages.ExportObjectWizard_5) + e.getMessage()));
            }
        }
        return p;
    }

    public IRepositoryApi getRepositoryConnection() {
        return this.sock;
    }

    public IVanillaAPI getVanillaApi() {
        if (this.vanillaApi == null) {
            IRepositoryContext ctx = Activator.getDefault().getDesignerActivator().getRepositoryContext();
            BaseVanillaContext vanillaCtx = new BaseVanillaContext(ctx.getVanillaContext().getVanillaUrl(), ctx.getVanillaContext().getLogin(), ctx.getVanillaContext().getPassword());
            this.vanillaApi = new RemoteVanillaPlatform((IVanillaContext)vanillaCtx);
        }
        return this.vanillaApi;
    }

    protected void setVanillaApi(IVanillaAPI vanillaApi) {
        this.vanillaApi = vanillaApi;
    }

    protected void setRepositoryConnection(IRepositoryApi sock) {
        this.sock = sock;
    }

    public IDesignerActivator<?> getDesignerActivator() {
        return this.designerActivator;
    }

    public boolean canFinish() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

