/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.viewers;

import bpm.vanilla.platform.core.repository.Repository;
import bpm.vanilla.platform.core.repository.RepositoryDirectory;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class RepositoryContentProvider
implements ITreeContentProvider {
    private Repository input;

    public Object[] getChildren(Object parentElement) {
        ArrayList l = new ArrayList();
        try {
            l.addAll(this.input.getChildDirectories((RepositoryDirectory)parentElement));
            l.addAll(this.input.getItems((RepositoryDirectory)parentElement));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RepositoryContentProvider_0, (String)(String.valueOf(Messages.RepositoryContentProvider_1) + ((RepositoryDirectory)parentElement).getName() + ":" + ex.getMessage()));
        }
        return l.toArray(new Object[l.size()]);
    }

    public Object getParent(Object element) {
        int dirId = -1;
        if (element instanceof RepositoryDirectory) {
            dirId = ((RepositoryDirectory)element).getParentId();
        } else if (element instanceof RepositoryItem) {
            dirId = ((RepositoryItem)element).getDirectoryId();
        }
        try {
            return this.input.getDirectory(dirId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof RepositoryItem) {
            return false;
        }
        try {
            return !this.input.getDirectoryContent((RepositoryDirectory)element).isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Object[] getElements(Object inputElement) {
        List l = new ArrayList();
        if (inputElement instanceof Repository) {
            this.input = (Repository)inputElement;
            try {
                l.addAll(this.input.getRootDirectories());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (inputElement instanceof List) {
            l = (List)inputElement;
        }
        return l.toArray(new Object[l.size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

