/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.versionning;

import bpm.repository.ui.SessionSourceProvider;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.services.ISourceProviderService;

public final class VersionningManager {
    private HashMap<String, Properties> modelProperties = new HashMap();
    private static VersionningManager instance = null;

    private VersionningManager() {
    }

    public static VersionningManager getInstance() {
        if (instance == null) {
            instance = new VersionningManager();
        }
        return instance;
    }

    public void saveChekout(String fileName, IRepositoryApi sock, RepositoryItem item) {
        try {
            Properties p = new Properties();
            p.setProperty("serverUrl", sock.getContext().getRepository().getUrl());
            p.setProperty("username", sock.getContext().getVanillaContext().getLogin());
            p.setProperty("password", sock.getContext().getVanillaContext().getPassword());
            p.setProperty("groupId", "" + sock.getContext().getGroup().getId());
            p.setProperty("directoryItemId", String.valueOf(item.getId()));
            this.modelProperties.put(fileName, p);
            this.save(String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "/resources/" + "versionning.xml");
            ISourceProviderService service = (ISourceProviderService)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getService(ISourceProviderService.class);
            SessionSourceProvider provider = (SessionSourceProvider)service.getSourceProvider("bpm.repository.ui.checkedIn");
            provider.setCheckedIn(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Properties getCheckoutInfos(String fileName) {
        for (String s : this.modelProperties.keySet()) {
            if (!s.equals(fileName)) continue;
            Properties p = this.modelProperties.get(s);
            return p;
        }
        return null;
    }

    public void performCheckin(String fileName) {
        ArrayList<String> keys = new ArrayList<String>(this.modelProperties.keySet());
        for (String s : keys) {
            if (!s.equals(fileName)) continue;
            this.modelProperties.remove(s);
        }
        ISourceProviderService service = (ISourceProviderService)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getService(ISourceProviderService.class);
        SessionSourceProvider provider = (SessionSourceProvider)service.getSourceProvider("bpm.repository.ui.checkedIn");
        provider.setCheckedIn(false);
    }

    protected void save(String fileName) throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("versionning");
        for (String key : this.modelProperties.keySet()) {
            Element checkout = root.addElement("checkout");
            checkout.addElement("fileName").setText(key);
            checkout.addElement("serverUrl").setText(this.modelProperties.get(key).getProperty("serverUrl"));
            checkout.addElement("username").setText(this.modelProperties.get(key).getProperty("username"));
            checkout.addElement("password").setText(this.modelProperties.get(key).getProperty("password"));
            if (this.modelProperties.get(key).getProperty("groupId") != null) {
                checkout.addElement("groupId").setText(this.modelProperties.get(key).getProperty("groupId"));
            }
            checkout.addElement("directoryItemId").setText(this.modelProperties.get(key).getProperty("directoryItemId"));
        }
        XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(fileName), OutputFormat.createPrettyPrint());
        xmlWriter.write(doc);
        xmlWriter.close();
    }

    public void load(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            f.createNewFile();
            this.save(fileName);
        }
        Document doc = DocumentHelper.parseText((String)IOUtils.toString((InputStream)new FileInputStream(fileName), (String)"UTF-8"));
        Element root = doc.getRootElement();
        for (Object o : root.elements("checkout")) {
            Element e = (Element)o;
            Properties p = new Properties();
            p.setProperty("serverUrl", e.elementText("serverUrl"));
            p.setProperty("username", e.elementText("username"));
            p.setProperty("password", e.elementText("password"));
            p.setProperty("directoryItemId", e.elementText("directoryItemId"));
            if (e.element("groupId") != null) {
                p.setProperty("groupId", e.elementText("groupId"));
            }
            this.modelProperties.put(e.elementText("fileName"), p);
        }
    }
}

