/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.dialogs;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.viewers.RepositoryLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogShowDependencies
extends Dialog {
    public static final String TITLE = Messages.DialogShowDependencies_0;
    public static final String UPDATE_TITLE = Messages.DialogShowDependencies_1;
    public static final String DELETE_TITLE = Messages.DialogShowDependencies_2;
    private RepositoryItem selectedItem;
    private TreeViewer tree;
    private IRepositoryApi sock;
    private List<TreeDirectoryItem> input;
    private String title;

    public DialogShowDependencies(Shell parentShell, RepositoryItem item, IRepositoryApi sock, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selectedItem = item;
        this.sock = sock;
        this.title = title;
    }

    protected void initializeBounds() {
        this.getShell().setText(this.title);
        this.getShell().setSize(600, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree = new TreeViewer(main, 2048);
        this.tree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider(){

            @Override
            public String getText(Object element) {
                RepositoryItem item = ((TreeDirectoryItem)element).getItem();
                return super.getText(item);
            }

            @Override
            public Image getImage(Object element) {
                RepositoryItem item = ((TreeDirectoryItem)element).getItem();
                return super.getImage(item);
            }
        });
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray(new Object[((List)inputElement).size()]);
            }

            public boolean hasChildren(Object element) {
                return ((TreeDirectoryItem)element).getChildren() != null && ((TreeDirectoryItem)element).getChildren().size() > 0;
            }

            public Object getParent(Object element) {
                return ((TreeDirectoryItem)element).getParent();
            }

            public Object[] getChildren(Object parentElement) {
                return ((TreeDirectoryItem)parentElement).getChildren().toArray(new Object[((TreeDirectoryItem)parentElement).getChildren().size()]);
            }
        });
        try {
            if (this.input == null) {
                this.hasDependencies();
            }
            this.tree.setInput(this.input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return main;
    }

    public boolean hasDependencies() throws Exception {
        new RemoteVanillaPlatform(this.sock.getContext().getVanillaContext());
        this.sock.getContext().getRepository();
        List items = this.sock.getRepositoryService().getDependantItems(this.selectedItem);
        ArrayList<TreeDirectoryItem> result = new ArrayList<TreeDirectoryItem>();
        for (RepositoryItem it : items) {
            TreeDirectoryItem tdi = new TreeDirectoryItem(it);
            result.add(tdi);
            tdi.setChildren(this.getChilds(it));
        }
        if (result.size() > 0) {
            this.input = result;
            return true;
        }
        return false;
    }

    private List<TreeDirectoryItem> getChilds(RepositoryItem parent) throws Exception {
        List items = this.sock.getRepositoryService().getDependantItems(parent);
        ArrayList<TreeDirectoryItem> result = new ArrayList<TreeDirectoryItem>();
        for (RepositoryItem it : items) {
            TreeDirectoryItem tdi = new TreeDirectoryItem(it);
            result.add(tdi);
            tdi.setChildren(this.getChilds(it));
        }
        return result;
    }

    private class TreeDirectoryItem {
        private RepositoryItem item;
        private List<TreeDirectoryItem> children;
        private TreeDirectoryItem parent;

        public TreeDirectoryItem(RepositoryItem item) {
            this.item = item;
        }

        public RepositoryItem getItem() {
            return this.item;
        }

        public void addChild(TreeDirectoryItem child) {
            if (this.children == null) {
                this.children = new ArrayList<TreeDirectoryItem>();
            }
            this.children.add(child);
        }

        public List<TreeDirectoryItem> getChildren() {
            return this.children;
        }

        public void setChildren(List<TreeDirectoryItem> children) {
            this.children = children;
        }

        public TreeDirectoryItem getParent() {
            return this.parent;
        }

        public void setParent(TreeDirectoryItem parent) {
            this.parent = parent;
        }
    }
}

