/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.dialogs;

import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.repository.ui.Messages;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogNewItem
extends Dialog {
    private Text itemName;
    private Text author;
    private Text description;
    private Text version;
    private CheckboxTableViewer table;
    public static final String P_NAME = "name";
    public static final String P_AUTHOR = "author";
    public static final String P_DESCRIPTION = "desc";
    public static final String P_VERSION = "version";
    public static final String P_GROUP = "group";
    private List<Group> groupList;
    private Properties props = new Properties();

    public DialogNewItem(Shell parentShell, List<Group> groups) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.groupList = groups;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(1808));
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.DialogNewItem_5);
        this.itemName = new Text(main, 2048);
        this.itemName.setLayoutData((Object)new GridData(4, 2, true, false));
        this.itemName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogNewItem.this.updateButton();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.DialogNewItem_6);
        this.description = new Text(main, 2048);
        this.description.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.DialogNewItem_7);
        this.version = new Text(main, 2048);
        this.version.setLayoutData((Object)new GridData(4, 2, true, false));
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.DialogNewItem_8);
        this.author = new Text(main, 2048);
        this.author.setLayoutData((Object)new GridData(4, 2, true, false));
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        l.setText(Messages.DialogNewItem_9);
        this.table = new CheckboxTableViewer(main, 68096);
        this.table.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.table.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DialogNewItem.this.updateButton();
            }
        });
        this.table.setInput(this.groupList);
        return parent;
    }

    protected void initializeBounds() {
        this.getShell().setText(Messages.DialogNewItem_10);
        this.getShell().setSize(400, 300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public Properties getProperties() {
        return this.props;
    }

    protected void okPressed() {
        this.props = new Properties();
        this.props.setProperty(P_DESCRIPTION, this.description.getText());
        this.props.setProperty(P_AUTHOR, this.author.getText());
        this.props.setProperty(P_NAME, this.itemName.getText());
        this.props.setProperty(P_VERSION, this.version.getText());
        boolean first = true;
        Object[] objectArray = this.table.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (first) {
                this.props.setProperty(P_GROUP, ((Group)o).getName());
                first = false;
            } else {
                this.props.setProperty(P_GROUP, String.valueOf(this.props.getProperty(P_GROUP)) + ";" + ((Group)o).getName());
            }
            ++n2;
        }
        super.okPressed();
    }

    private void updateButton() {
        boolean enabled = this.table.getCheckedElements().length > 0;
        enabled = enabled && !this.itemName.getText().isEmpty();
        this.getButton(0).setEnabled(enabled);
    }
}

