/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.dialogs;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.repository.ui.Messages;
import java.io.File;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogLinkedDocument
extends Dialog {
    private Text displayName;
    private Text comment;
    private Text file;
    private Combo groups;
    private File document;
    private String _comment;
    private String display;
    private Collection<String> groupInput;
    private String groupSelected;

    public DialogLinkedDocument(Shell parentShell, Collection<String> groups) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.groupInput = groups;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        main.setLayoutData((Object)new GridData(1808));
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.DialogLinkedDocument_0);
        this.displayName = new Text(main, 2048);
        this.displayName.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.displayName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogLinkedDocument.this.updateButtons();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.DialogLinkedDocument_1);
        this.file = new Text(main, 2048);
        this.file.setLayoutData((Object)new GridData(4, 2, true, false));
        this.file.setEnabled(false);
        Button b = new Button(main, 8);
        b.setLayoutData((Object)new GridData(3, 2, false, false));
        b.setText("...");
        b.setToolTipText(Messages.DialogLinkedDocument_3);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(DialogLinkedDocument.this.getShell(), 4096);
                fd.setFilterExtensions(IRepositoryApi.AVAILABLE_FORMATS);
                DialogLinkedDocument.this.document = new File(fd.open());
                if (!DialogLinkedDocument.this.document.exists()) {
                    DialogLinkedDocument.this.document = null;
                } else {
                    DialogLinkedDocument.this.file.setText(DialogLinkedDocument.this.document.getAbsolutePath());
                    DialogLinkedDocument.this.updateButtons();
                }
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText(Messages.DialogLinkedDocument_4);
        this.groups = new Combo(main, 8);
        this.groups.setItems(this.groupInput.toArray(new String[this.groupInput.size()]));
        this.groups.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        if (!this.groupInput.isEmpty()) {
            this.groups.select(0);
        }
        this.groups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogLinkedDocument.this.updateButtons();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 4, false, true));
        l.setText(Messages.DialogLinkedDocument_5);
        this.comment = new Text(main, 2048);
        this.comment.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        return main;
    }

    private void updateButtons() {
        if (this.document == null || "".equals(this.displayName.getText().trim()) || this.groups.getSelectionIndex() < 0) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void okPressed() {
        this.display = this.displayName.getText();
        this._comment = this.comment.getText();
        this.groupSelected = this.groups.getText();
        super.okPressed();
    }

    public String getGroup() {
        return this.groupSelected;
    }

    public File getFile() {
        return this.document;
    }

    public String getDisplayName() {
        return this.display;
    }

    public String getComment() {
        return this._comment;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void initializeBounds() {
        this.getShell().setSize(600, 400);
        this.getShell().setText(Messages.DialogLinkedDocument_7);
    }
}

