/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.dialogs;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.repository.Repository;
import bpm.vanilla.platform.core.repository.RepositoryDirectory;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.composites.CompositeRepositoryItemSelecter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DialogDirectoryPicker
extends Dialog {
    private IRepositoryApi sock;
    private CompositeRepositoryItemSelecter viewer;
    private RepositoryDirectory directory;

    public DialogDirectoryPicker(Shell parentShell, IRepositoryApi sock) {
        super(parentShell);
        this.sock = sock;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.viewer = new CompositeRepositoryItemSelecter(parent, 2048);
        this.viewer.setLayoutData(new GridData(1808));
        this.viewer.addViewerFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof RepositoryDirectory;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DialogDirectoryPicker.this.getButton(0).setEnabled(!DialogDirectoryPicker.this.viewer.getSelectedItems().isEmpty());
            }
        });
        try {
            this.viewer.setInput(new Repository(this.sock));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.viewer;
    }

    protected void initializeBounds() {
        this.getShell().setText(Messages.DialogDirectoryPicker_0);
        this.getShell().setSize(600, 400);
    }

    protected void okPressed() {
        this.directory = (RepositoryDirectory)this.viewer.getSelectedItems().get(0);
        super.okPressed();
    }

    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public int getDirectoryId() {
        return this.directory.getId();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.DialogDirectoryPicker_1, true).setEnabled(false);
    }
}

