/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.dialogs;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.repository.Repository;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.composites.CompositeRepositoryItemSelecter;
import bpm.vanilla.repository.ui.viewers.RepositoryViewerFilter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DialogDirectoryItemPicker
extends Dialog {
    private IRepositoryApi sock;
    private CompositeRepositoryItemSelecter viewer;
    private RepositoryItem directoryItem;
    private int[] type;
    private int[] subtype;

    public DialogDirectoryItemPicker(Shell parentShell, IRepositoryApi sock, int[] type, int[] subtype) {
        super(parentShell);
        this.sock = sock;
        this.type = type;
        this.subtype = subtype;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.viewer = new CompositeRepositoryItemSelecter(parent, 2048);
        this.viewer.setLayoutData(new GridData(1808));
        this.viewer.addViewerFilter(new RepositoryViewerFilter(this.type, this.subtype));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DialogDirectoryItemPicker.this.getButton(0).setEnabled(!DialogDirectoryItemPicker.this.viewer.getSelectedItems().isEmpty() && DialogDirectoryItemPicker.this.viewer.getSelectedItems().get(0) instanceof RepositoryItem);
            }
        });
        try {
            this.viewer.setInput(new Repository(this.sock));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.viewer;
    }

    protected void initializeBounds() {
        this.getShell().setText(Messages.DialogDirectoryItemPicker_0);
        this.getShell().setSize(600, 400);
    }

    protected void okPressed() {
        this.directoryItem = (RepositoryItem)this.viewer.getSelectedItems().get(0);
        super.okPressed();
    }

    public RepositoryItem getDirectoryItem() {
        return this.directoryItem;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.DialogDirectoryItemPicker_1, true).setEnabled(false);
    }
}

