/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.connection;

import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.repository.ui.connection.VanillaServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class VanillaServerManager {
    private static VanillaServerManager instance = null;
    private HashMap<String, IRepositoryContext> servers = new HashMap();

    private VanillaServerManager() {
    }

    public static VanillaServerManager getInstance() {
        if (instance == null) {
            instance = new VanillaServerManager();
        }
        return instance;
    }

    public void saveServer(String serverName, IRepositoryContext ctx) {
        try {
            this.servers.put(serverName, ctx);
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void save() throws Exception {
        String userHome = System.getProperty("user.home");
        String pathToDirectory = String.valueOf(userHome) + File.separator + ".bpmconseil" + File.separator + "serie8" + File.separator + "common" + File.separator;
        File directory = new File(pathToDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = String.valueOf(pathToDirectory) + "servers.xml";
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("servers");
        if (this.servers != null) {
            for (String key : this.servers.keySet()) {
                IRepositoryContext ctx = this.servers.get(key);
                IVanillaContext vanillaCtx = ctx.getVanillaContext();
                Element server = root.addElement("server");
                server.addElement("serverName").setText(key);
                server.addElement("serverUrl").setText(vanillaCtx.getVanillaUrl());
                server.addElement("username").setText(vanillaCtx.getLogin());
                server.addElement("password").setText(vanillaCtx.getPassword());
                server.addElement("groupId").setText(String.valueOf(ctx.getGroup().getId()));
                server.addElement("groupName").setText(ctx.getGroup().getName());
                server.addElement("repositoryId").setText(String.valueOf(ctx.getRepository().getId()));
                server.addElement("repositoryName").setText(ctx.getRepository().getName());
            }
        }
        XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(fileName), OutputFormat.createPrettyPrint());
        xmlWriter.write(doc);
        xmlWriter.close();
    }

    public void load() throws Exception {
        Document doc;
        Element root;
        String fileName;
        File f;
        String userHome = System.getProperty("user.home");
        String pathToDirectory = String.valueOf(userHome) + File.separator + ".bpmconseil" + File.separator + "serie8" + File.separator + "common" + File.separator;
        File directory = new File(pathToDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(f = new File(fileName = String.valueOf(pathToDirectory) + "servers.xml")).exists()) {
            f.createNewFile();
            this.save();
        }
        if ((root = (doc = DocumentHelper.parseText((String)IOUtils.toString((InputStream)new FileInputStream(fileName), (String)"UTF-8"))).getRootElement()).elements("server") != null) {
            for (Object o : root.elements("server")) {
                Element e = (Element)o;
                String serverName = e.elementText("serverName");
                String serverUrl = e.elementText("serverUrl");
                String username = e.elementText("username");
                String password = e.elementText("password");
                String groupId = e.elementText("groupId");
                String groupName = e.elementText("groupName");
                String repositoryId = e.elementText("repositoryId");
                String repositoryName = e.elementText("repositoryName");
                BaseVanillaContext vanillaCtx = new BaseVanillaContext(serverUrl, username, password);
                Group dummyGroup = new Group();
                dummyGroup.setId(Integer.valueOf(Integer.parseInt(groupId)));
                dummyGroup.setName(groupName);
                Repository dummyRepository = new Repository();
                dummyRepository.setId(Integer.parseInt(repositoryId));
                dummyRepository.setName(repositoryName);
                this.servers.put(serverName, (IRepositoryContext)new BaseRepositoryContext((IVanillaContext)vanillaCtx, dummyGroup, dummyRepository));
            }
        }
    }

    public void delete(String serverName) throws Exception {
        this.servers.remove(serverName);
        this.save();
    }

    public List<VanillaServer> getServers() {
        ArrayList<VanillaServer> servs = new ArrayList<VanillaServer>();
        if (this.servers != null) {
            for (String key : this.servers.keySet()) {
                IRepositoryContext server = this.servers.get(key);
                servs.add(new VanillaServer(key, server));
            }
        }
        return servs;
    }
}

