/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.connection;

import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.connection.VanillaServer;
import bpm.vanilla.repository.ui.connection.VanillaServerManager;
import bpm.vanilla.repository.ui.viewers.RepositoryLabelProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogVanillaServer
extends Dialog {
    private Text txtServerName;
    private Text host;
    private Text login;
    private Text password;
    private static Font font = new Font((Device)Display.getCurrent(), "Times New Roman", 12, 2);
    private ComboViewer repositories;
    private ComboViewer groups;
    private BaseVanillaContext vanillaCtx;
    private Button loadGroups;
    private ModifyListener lst = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DialogVanillaServer.this.groups.setInput((Object)Collections.EMPTY_LIST);
            DialogVanillaServer.this.repositories.setInput((Object)Collections.EMPTY_LIST);
            Button b = DialogVanillaServer.this.getButton(0);
            b.setEnabled(false);
        }
    };
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Button b = DialogVanillaServer.this.getButton(0);
            if (b != null) {
                if (DialogVanillaServer.this.groups.getSelection().isEmpty() || DialogVanillaServer.this.repositories.getSelection().isEmpty()) {
                    b.setEnabled(false);
                } else {
                    b.setEnabled(true);
                }
            }
        }
    };
    private VanillaServer server;

    public DialogVanillaServer(Shell parentShell, VanillaServer server) {
        super(parentShell);
        this.server = server;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void initializeBounds() {
        this.getShell().setText("Vanilla Platform Connection");
        super.initializeBounds();
        this.getShell().setSize(400, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label l3 = new Label(container, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText(Messages.DialogVanillaServer_0);
        l3.setFont(font);
        this.txtServerName = new Text(container, 2048);
        this.txtServerName.setLayoutData((Object)new GridData(4, 2, true, false));
        l3 = new Label(container, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText(Messages.DialogConnect_0);
        l3.setFont(font);
        this.host = new Text(container, 2048);
        this.host.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l6 = new Label(container, 0);
        l6.setLayoutData((Object)new GridData(1, 2, false, false));
        l6.setText(Messages.DialogConnect_1);
        l6.setFont(font);
        this.login = new Text(container, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText(Messages.DialogConnect_2);
        l7.setFont(font);
        this.password = new Text(container, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false));
        this.loadGroups = new Button(container, 8);
        this.loadGroups.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        this.loadGroups.setText(Messages.DialogConnect_3);
        this.loadGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DialogVanillaServer.this.connect(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DialogVanillaServer.this.groups.setInput((Object)Collections.EMPTY_LIST);
                    DialogVanillaServer.this.repositories.setInput((Object)Collections.EMPTY_LIST);
                    DialogVanillaServer.this.vanillaCtx = null;
                    MessageDialog.openError((Shell)DialogVanillaServer.this.getShell(), (String)Messages.DialogConnect_4, (String)(String.valueOf(Messages.DialogConnect_5) + ex.getMessage()));
                }
            }
        });
        l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText(Messages.DialogConnect_6);
        l7.setFont(font);
        this.groups = new ComboViewer(container, 8);
        this.groups.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.groups.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        this.groups.setContentProvider((IContentProvider)new ArrayContentProvider());
        l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText(Messages.DialogConnect_7);
        l7.setFont(font);
        this.repositories = new ComboViewer(container, 8);
        this.repositories.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.repositories.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.repositories.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.groups.addSelectionChangedListener(this.listener);
        this.repositories.addSelectionChangedListener(this.listener);
        this.fill(true, this.server);
        return container;
    }

    private void connect(boolean isTimedOut) throws Exception {
        this.vanillaCtx = new BaseVanillaContext(this.host.getText(), this.login.getText(), this.password.getText());
        RemoteVanillaPlatform vanillaApi = new RemoteVanillaPlatform((IVanillaContext)this.vanillaCtx);
        User user = vanillaApi.getVanillaSecurityManager().authentify("", this.vanillaCtx.getLogin(), this.vanillaCtx.getPassword(), isTimedOut);
        this.repositories.setInput((Object)vanillaApi.getVanillaRepositoryManager().getUserRepositories(this.login.getText()));
        this.groups.setInput((Object)vanillaApi.getVanillaSecurityManager().getGroups(user));
    }

    private void fill(boolean isTimedOut, VanillaServer server) {
        block6: {
            if (server != null) {
                String serverName = server.getName();
                IRepositoryContext ctx = server.getCtx();
                this.txtServerName.setText(serverName != null ? serverName : "");
                this.txtServerName.setEditable(serverName == null);
                this.login.setText(ctx.getVanillaContext().getLogin());
                this.password.setText(ctx.getVanillaContext().getPassword());
                this.host.setText(ctx.getVanillaContext().getVanillaUrl());
                try {
                    this.connect(isTimedOut);
                    if (this.groups.getInput() != null) {
                        for (Group g : (List)this.groups.getInput()) {
                            if (!g.getId().equals(ctx.getGroup().getId())) continue;
                            this.groups.setSelection((ISelection)new StructuredSelection((Object)g));
                            break;
                        }
                    }
                    if (this.repositories.getInput() == null) break block6;
                    for (Group g : (List)this.repositories.getInput()) {
                        if (g.getId() != ctx.getRepository().getId()) continue;
                        this.repositories.setSelection((ISelection)new StructuredSelection((Object)g));
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.login.addModifyListener(this.lst);
        this.password.addModifyListener(this.lst);
        this.host.addModifyListener(this.lst);
    }

    protected void okPressed() {
        try {
            this.repositories.removeSelectionChangedListener(this.listener);
            this.groups.removeSelectionChangedListener(this.listener);
            Group selectedGroup = (Group)((IStructuredSelection)this.groups.getSelection()).getFirstElement();
            RemoteVanillaPlatform vanillaApi = new RemoteVanillaPlatform((IVanillaContext)this.vanillaCtx);
            if (vanillaApi.getVanillaSecurityManager().canAccessApp(selectedGroup.getId().intValue(), Activator.getDefault().getDesignerActivator().getApplicationId())) {
                String serverName = this.txtServerName.getText();
                BaseRepositoryContext context = new BaseRepositoryContext((IVanillaContext)this.vanillaCtx, selectedGroup, (Repository)((IStructuredSelection)this.repositories.getSelection()).getFirstElement());
                VanillaServerManager.getInstance().saveServer(serverName, (IRepositoryContext)context);
                super.okPressed();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.DialogVanillaServer_3, (String)Messages.DialogVanillaServer_4);
            }
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DialogConnect_11, (String)ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.server != null ? Messages.DialogVanillaServer_5 : Messages.DialogVanillaServer_6, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

