/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.connection;

import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.connection.D4CServer;
import bpm.vanilla.repository.ui.connection.D4CServerManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogD4CServer
extends Dialog {
    private Text txtServerName;
    private Text host;
    private Text login;
    private Text password;
    private static Font font = new Font((Device)Display.getCurrent(), "Times New Roman", 12, 2);
    private D4CServer server;

    public DialogD4CServer(Shell parentShell, D4CServer server) {
        super(parentShell);
        this.server = server;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void initializeBounds() {
        this.getShell().setText("D4C");
        super.initializeBounds();
        this.getShell().setSize(400, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label l3 = new Label(container, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText("Nom du serveur");
        l3.setFont(font);
        this.txtServerName = new Text(container, 2048);
        this.txtServerName.setLayoutData((Object)new GridData(4, 2, true, false));
        l3 = new Label(container, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText("URL");
        l3.setFont(font);
        this.host = new Text(container, 2048);
        this.host.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l6 = new Label(container, 0);
        l6.setLayoutData((Object)new GridData(1, 2, false, false));
        l6.setText("Login");
        l6.setFont(font);
        this.login = new Text(container, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l7 = new Label(container, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText("Mot de passe");
        l7.setFont(font);
        this.password = new Text(container, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fill(true, this.server);
        return container;
    }

    private void fill(boolean isTimedOut, D4CServer server) {
        if (server != null) {
            String serverName = server.getName();
            String url = server.getUrl();
            String d4cLogin = server.getLogin();
            String d4cPassword = server.getPassword();
            this.txtServerName.setText(serverName != null ? serverName : "");
            this.txtServerName.setEditable(serverName == null);
            this.login.setText(d4cLogin);
            this.password.setText(d4cPassword);
            this.host.setText(url);
        }
    }

    protected void okPressed() {
        try {
            String serverName = this.txtServerName.getText();
            String d4cUrl = this.host.getText();
            String d4cLogin = this.login.getText();
            String d4cPassword = this.password.getText();
            D4CServerManager.getInstance().saveServer(serverName, new D4CServer(serverName, d4cUrl, d4cLogin, d4cPassword));
            super.okPressed();
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DialogConnect_11, (String)ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.server != null ? Messages.DialogVanillaServer_5 : Messages.DialogVanillaServer_6, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

