/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.connection;

import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.connection.DialogVanillaServer;
import bpm.vanilla.repository.ui.connection.VanillaServer;
import bpm.vanilla.repository.ui.connection.VanillaServerManager;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogConnect
extends Dialog {
    private ComboViewer cbServers;
    private static Font font = new Font((Device)Display.getCurrent(), "Times New Roman", 12, 2);
    private IRepositoryContext context;

    public DialogConnect(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void initializeBounds() {
        this.getShell().setText("Vanilla Platform Connection");
        super.initializeBounds();
        this.getShell().setSize(400, 150);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(5, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblServers = new Label(container, 0);
        lblServers.setLayoutData((Object)new GridData(1, 2, false, false));
        lblServers.setText("Serveurs");
        lblServers.setFont(font);
        this.cbServers = new ComboViewer(container, 8);
        this.cbServers.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.cbServers.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((VanillaServer)element).getName();
            }
        });
        this.cbServers.setContentProvider((IContentProvider)new ArrayContentProvider());
        ImageDescriptor addImage = Activator.getDefault().getImageRegistry().getDescriptor("add.png");
        Button btnAddServer = new Button(container, 8);
        btnAddServer.setLayoutData((Object)new GridData(3, 2, false, false));
        btnAddServer.setToolTipText("Add new server");
        btnAddServer.setImage(addImage.createImage());
        btnAddServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogVanillaServer d = new DialogVanillaServer(DialogConnect.this.getShell(), null);
                if (d.open() == 0) {
                    DialogConnect.this.fill(true);
                }
            }
        });
        ImageDescriptor editImage = Activator.getDefault().getImageRegistry().getDescriptor("jasper.png");
        Button editServer = new Button(container, 8);
        editServer.setLayoutData((Object)new GridData(3, 2, false, false));
        editServer.setToolTipText("Edit server");
        editServer.setImage(editImage.createImage());
        editServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VanillaServer server = (VanillaServer)((IStructuredSelection)DialogConnect.this.cbServers.getSelection()).getFirstElement();
                if (server == null) {
                    return;
                }
                DialogVanillaServer d = new DialogVanillaServer(DialogConnect.this.getShell(), server);
                if (d.open() == 0) {
                    DialogConnect.this.fill(true);
                }
            }
        });
        ImageDescriptor delImage = Activator.getDefault().getImageRegistry().getDescriptor("del.png");
        Button deleteServer = new Button(container, 8);
        deleteServer.setLayoutData((Object)new GridData(3, 2, false, false));
        deleteServer.setToolTipText("Delete server");
        deleteServer.setImage(delImage.createImage());
        deleteServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VanillaServer server = (VanillaServer)((IStructuredSelection)DialogConnect.this.cbServers.getSelection()).getFirstElement();
                if (server == null) {
                    return;
                }
                try {
                    VanillaServerManager.getInstance().delete(server.getName());
                    DialogConnect.this.fill(true);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.fill(true);
        return container;
    }

    private void fill(boolean isTimedOut) {
        try {
            VanillaServerManager.getInstance().load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<VanillaServer> servers = VanillaServerManager.getInstance().getServers();
        this.cbServers.setInput(servers);
    }

    protected void okPressed() {
        block5: {
            try {
                VanillaServer server = (VanillaServer)((IStructuredSelection)this.cbServers.getSelection()).getFirstElement();
                IRepositoryContext repCtx = server.getCtx();
                RemoteVanillaPlatform vanillaApi = new RemoteVanillaPlatform(repCtx.getVanillaContext());
                Group selectedGroup = repCtx.getGroup();
                if (vanillaApi.getVanillaSecurityManager().canAccessApp(selectedGroup.getId().intValue(), Activator.getDefault().getDesignerActivator().getApplicationId())) {
                    this.context = repCtx;
                    try {
                        Activator.getDefault().getDesignerActivator().setRepositoryContext(repCtx);
                    }
                    catch (Exception exception) {}
                    super.okPressed();
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.DialogConnect_9, (String)Messages.DialogConnect_10);
                    break block5;
                }
                MessageDialog.openError((Shell)this.getShell(), (String)"User Rights", (String)"You are not allowed to access this application.");
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.DialogConnect_11, (String)ex.getMessage());
                Activator.getDefault().getDesignerActivator().setRepositoryContext(null);
                ex.printStackTrace();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.DialogConnect_12, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public IRepositoryContext getRepositoryContext() {
        return this.context;
    }
}

