/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.connection;

import bpm.vanilla.repository.ui.connection.D4CServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class D4CServerManager {
    private static D4CServerManager instance = null;
    private HashMap<String, D4CServer> servers = new HashMap();

    private D4CServerManager() {
    }

    public static D4CServerManager getInstance() {
        if (instance == null) {
            instance = new D4CServerManager();
        }
        return instance;
    }

    public void saveServer(String serverName, D4CServer ctx) {
        try {
            this.servers.put(serverName, ctx);
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void save() throws Exception {
        String userHome = System.getProperty("user.home");
        String pathToDirectory = String.valueOf(userHome) + File.separator + ".bpmconseil" + File.separator + "serie8" + File.separator + "common" + File.separator;
        File directory = new File(pathToDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = String.valueOf(pathToDirectory) + "servers_d4c.xml";
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("servers");
        if (this.servers != null) {
            for (String key : this.servers.keySet()) {
                D4CServer d4cServer = this.servers.get(key);
                Element server = root.addElement("server");
                server.addElement("serverName").setText(key);
                server.addElement("serverUrl").setText(d4cServer.getUrl());
                server.addElement("username").setText(d4cServer.getLogin());
                server.addElement("password").setText(d4cServer.getPassword());
            }
        }
        XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(fileName), OutputFormat.createPrettyPrint());
        xmlWriter.write(doc);
        xmlWriter.close();
    }

    public void load() throws Exception {
        Document doc;
        Element root;
        String fileName;
        File f;
        String userHome = System.getProperty("user.home");
        String pathToDirectory = String.valueOf(userHome) + File.separator + ".bpmconseil" + File.separator + "serie8" + File.separator + "common" + File.separator;
        File directory = new File(pathToDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(f = new File(fileName = String.valueOf(pathToDirectory) + "servers_d4c.xml")).exists()) {
            f.createNewFile();
            this.save();
        }
        if ((root = (doc = DocumentHelper.parseText((String)IOUtils.toString((InputStream)new FileInputStream(fileName), (String)"UTF-8"))).getRootElement()).elements("server") != null) {
            for (Object o : root.elements("server")) {
                Element e = (Element)o;
                String serverName = e.elementText("serverName");
                String serverUrl = e.elementText("serverUrl");
                String username = e.elementText("username");
                String password = e.elementText("password");
                D4CServer server = new D4CServer(serverName, serverUrl, username, password);
                this.servers.put(serverName, server);
            }
        }
    }

    public void delete(String serverName) throws Exception {
        this.servers.remove(serverName);
        this.save();
    }

    public List<D4CServer> getServers() {
        ArrayList<D4CServer> servs = new ArrayList<D4CServer>();
        if (this.servers != null) {
            for (String key : this.servers.keySet()) {
                D4CServer server = this.servers.get(key);
                servs.add(server);
            }
        }
        return servs;
    }
}

