/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.connection;

import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.connection.DialogVanillaServer;
import bpm.vanilla.repository.ui.connection.VanillaServer;
import bpm.vanilla.repository.ui.connection.VanillaServerManager;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompositeWelcomeConnectionTab
extends Composite {
    private ComboViewer cbServers;
    private static Font font = new Font((Device)Display.getCurrent(), "Times New Roman", 12, 2);

    public CompositeWelcomeConnectionTab(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    public IRepositoryContext getRepositoryContext() throws Exception {
        VanillaServer server = (VanillaServer)((IStructuredSelection)this.cbServers.getSelection()).getFirstElement();
        IRepositoryContext repCtx = server.getCtx();
        if (!new RemoteVanillaPlatform(repCtx.getVanillaContext()).getVanillaSecurityManager().canAccessApp(repCtx.getGroup().getId().intValue(), Activator.getDefault().getDesignerActivator().getApplicationId())) {
            throw new Exception(Messages.CompositeWelcomeConnectionTab_0);
        }
        return repCtx;
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(5, false));
        this.setLayoutData(new GridData(1808));
        CompositeWelcomeConnectionTab container = this;
        Label lblServers = new Label((Composite)container, 0);
        lblServers.setLayoutData((Object)new GridData(1, 2, false, false));
        lblServers.setText(Messages.CompositeWelcomeConnectionTab_1);
        lblServers.setFont(font);
        this.cbServers = new ComboViewer((Composite)container, 8);
        this.cbServers.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.cbServers.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((VanillaServer)element).getName();
            }
        });
        this.cbServers.setContentProvider((IContentProvider)new ArrayContentProvider());
        ImageDescriptor addImage = Activator.getDefault().getImageRegistry().getDescriptor("add.png");
        Button btnAddServer = new Button((Composite)container, 8);
        btnAddServer.setLayoutData((Object)new GridData(3, 2, false, false));
        btnAddServer.setToolTipText(Messages.CompositeWelcomeConnectionTab_2);
        btnAddServer.setImage(addImage.createImage());
        btnAddServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogVanillaServer d = new DialogVanillaServer(CompositeWelcomeConnectionTab.this.getShell(), null);
                if (d.open() == 0) {
                    CompositeWelcomeConnectionTab.this.fill();
                }
            }
        });
        ImageDescriptor editImage = Activator.getDefault().getImageRegistry().getDescriptor("jasper.png");
        Button editServer = new Button((Composite)container, 8);
        editServer.setLayoutData((Object)new GridData(3, 2, false, false));
        editServer.setToolTipText(Messages.CompositeWelcomeConnectionTab_3);
        editServer.setImage(editImage.createImage());
        editServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VanillaServer server = (VanillaServer)((IStructuredSelection)CompositeWelcomeConnectionTab.this.cbServers.getSelection()).getFirstElement();
                if (server == null) {
                    return;
                }
                DialogVanillaServer d = new DialogVanillaServer(CompositeWelcomeConnectionTab.this.getShell(), server);
                if (d.open() == 0) {
                    CompositeWelcomeConnectionTab.this.fill();
                }
            }
        });
        ImageDescriptor delImage = Activator.getDefault().getImageRegistry().getDescriptor("del.png");
        Button deleteServer = new Button((Composite)container, 8);
        deleteServer.setLayoutData((Object)new GridData(3, 2, false, false));
        deleteServer.setToolTipText(Messages.CompositeWelcomeConnectionTab_4);
        deleteServer.setImage(delImage.createImage());
        deleteServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VanillaServer server = (VanillaServer)((IStructuredSelection)CompositeWelcomeConnectionTab.this.cbServers.getSelection()).getFirstElement();
                if (server == null) {
                    return;
                }
                try {
                    VanillaServerManager.getInstance().delete(server.getName());
                    CompositeWelcomeConnectionTab.this.fill();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.fill();
    }

    private void fill() {
        try {
            VanillaServerManager.getInstance().load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<VanillaServer> servers = VanillaServerManager.getInstance().getServers();
        this.cbServers.setInput(servers);
    }
}

