/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.composites;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.viewers.RepositoryContentProvider;
import bpm.vanilla.repository.ui.viewers.RepositoryLabelProvider;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CompositeRepositorySelecter
extends Composite {
    private Text vanillaUrl;
    private Text vanillaLogin;
    private Text vanillaPassword;
    private Button loadRepositories;
    private ComboViewer repositorySelecter;
    private IRepositoryApi sock;
    private IVanillaContext vanillaContext;

    public CompositeRepositorySelecter(Composite parent, int style) {
        super(parent, style);
        this.buildContent();
    }

    private void buildContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)this, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositeRepositorySelecter_0);
        this.vanillaUrl = new Text((Composite)this, 2048);
        this.vanillaUrl.setLayoutData((Object)new GridData(4, 2, true, false));
        this.vanillaUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeRepositorySelecter.this.updateButtonState();
            }
        });
        l = new Label((Composite)this, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositeRepositorySelecter_1);
        this.vanillaLogin = new Text((Composite)this, 2048);
        this.vanillaLogin.setLayoutData((Object)new GridData(4, 2, true, false));
        this.vanillaLogin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeRepositorySelecter.this.updateButtonState();
            }
        });
        l = new Label((Composite)this, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositeRepositorySelecter_2);
        this.vanillaPassword = new Text((Composite)this, 0x400800);
        this.vanillaPassword.setLayoutData((Object)new GridData(4, 2, true, false));
        this.vanillaPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeRepositorySelecter.this.updateButtonState();
            }
        });
        this.loadRepositories = new Button((Composite)this, 8);
        this.loadRepositories.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.loadRepositories.setText(Messages.CompositeRepositorySelecter_3);
        this.loadRepositories.setEnabled(false);
        this.loadRepositories.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CompositeRepositorySelecter.this.loadRepositoriesDefinition();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openError((Shell)CompositeRepositorySelecter.this.getShell(), (String)Messages.CompositeRepositorySelecter_4, (String)e1.getMessage());
                }
            }
        });
        l = new Label((Composite)this, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositeRepositorySelecter_5);
        this.repositorySelecter = new ComboViewer((Composite)this, 8);
        this.repositorySelecter.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.repositorySelecter.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.repositorySelecter.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.repositorySelecter.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Event e = new Event();
                e.item = CompositeRepositorySelecter.this.repositorySelecter.getCombo();
                if (!CompositeRepositorySelecter.this.repositorySelecter.getSelection().isEmpty()) {
                    e.data = ((IStructuredSelection)CompositeRepositorySelecter.this.repositorySelecter.getSelection()).getFirstElement();
                }
                CompositeRepositorySelecter.this.notifyListeners(13, e);
            }
        });
    }

    private void updateButtonState() {
        boolean enabled = !"".equals(this.vanillaUrl.getText()) && !"".equals(this.vanillaLogin.getText()) && !"".equals(this.vanillaPassword.getText());
        this.loadRepositories.setEnabled(enabled);
    }

    public Repository getSelectedRepositoryDefinition() {
        if (!this.repositorySelecter.getSelection().isEmpty()) {
            return (Repository)((IStructuredSelection)this.repositorySelecter.getSelection()).getFirstElement();
        }
        return null;
    }

    public String getVanillaUrl() {
        try {
            return this.vanillaUrl.getText();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public IRepositoryApi getRepositorySocket() {
        boolean hasChanged;
        boolean bl = hasChanged = this.sock != null;
        if (hasChanged) {
            hasChanged = false;
            IRepositoryContext repCtx = this.sock.getContext();
            boolean bl2 = hasChanged = !repCtx.getVanillaContext().getLogin().equals(this.vanillaLogin.getText()) || !repCtx.getVanillaContext().equals(this.vanillaPassword.getText()) || repCtx.getRepository().getId() != this.getSelectedRepositoryDefinition().getId();
        }
        if (this.sock == null || hasChanged) {
            try {
                Group dumyy = new Group();
                dumyy.setId(Integer.valueOf(-1));
                this.sock = new RemoteRepositoryApi((IRepositoryContext)new BaseRepositoryContext((IVanillaContext)new BaseVanillaContext(this.vanillaUrl.getText(), this.vanillaLogin.getText(), this.vanillaPassword.getText()), dumyy, this.getSelectedRepositoryDefinition()));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.sock;
    }

    public void fill(String login, String password, String url, Integer repositoryId) {
        this.vanillaUrl.setText(url != null ? url : "");
        this.vanillaLogin.setText(login != null ? login : "");
        this.vanillaPassword.setText(password != null ? password : "");
        try {
            this.loadRepositoriesDefinition();
            if (this.repositorySelecter.getInput() != null) {
                for (Object o : (Collection)this.repositorySelecter.getInput()) {
                    if (((Repository)o).getId() != repositoryId.intValue()) continue;
                    this.repositorySelecter.setSelection((ISelection)new StructuredSelection(o));
                }
            }
        }
        catch (Exception exception) {}
    }

    private void loadRepositoriesDefinition() throws Exception {
        RemoteVanillaPlatform api = new RemoteVanillaPlatform(this.vanillaUrl.getText(), this.vanillaLogin.getText(), this.vanillaPassword.getText());
        try {
            this.repositorySelecter.setInput((Object)api.getVanillaRepositoryManager().getUserRepositories(this.vanillaLogin.getText()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(String.valueOf(Messages.CompositeRepositorySelecter_12) + ex.getMessage(), ex);
        }
    }

    public void enableConnectionFields(boolean b) {
        this.vanillaLogin.setEnabled(b);
        this.vanillaPassword.setEnabled(b);
        this.vanillaUrl.setEnabled(b);
    }

    public IVanillaContext getVanillaContext() {
        if (this.vanillaContext == null) {
            this.vanillaContext = new BaseVanillaContext(this.vanillaUrl.getText(), this.vanillaLogin.getText(), this.vanillaPassword.getText());
        }
        return this.vanillaContext;
    }
}

