/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui.composites;

import bpm.vanilla.platform.core.repository.Repository;
import bpm.vanilla.platform.core.repository.RepositoryDirectory;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.viewers.RepositoryTreeViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CompositeRepositoryItemSelecter
extends Composite {
    private RepositoryTreeViewer repositoryViewer;

    public CompositeRepositoryItemSelecter(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.buildContent();
    }

    public StructuredViewer getViewer() {
        return this.repositoryViewer;
    }

    private void buildContent() {
        this.repositoryViewer = new RepositoryTreeViewer(this, 0x800 | this.getStyle());
        this.repositoryViewer.getTree().setLayoutData((Object)new GridData(1808));
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.repositoryViewer.addFilter(filter);
    }

    public void removeViewerFilter(ViewerFilter filter) {
        this.repositoryViewer.removeFilter(filter);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.repositoryViewer.addSelectionChangedListener(listener);
    }

    public void setInput(Object repositoryContent) {
        this.repositoryViewer.setInput(repositoryContent);
    }

    public void selectDirectoryItem(Integer directoryItemId) {
        if (this.repositoryViewer.getInput() != null) {
            try {
                if (directoryItemId != null) {
                    RepositoryItem it = this.getInput().getItem(directoryItemId.intValue());
                    if (it != null) {
                        RepositoryDirectory d = this.getInput().getDirectory(it.getDirectoryId());
                        while (d != null) {
                            this.repositoryViewer.setExpandedState(d, true);
                            d = this.getInput().getDirectory(d.getParentId());
                        }
                        this.repositoryViewer.setSelection((ISelection)new StructuredSelection((Object)it));
                    } else {
                        this.repositoryViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                } else {
                    this.repositoryViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Repository getInput() {
        return (Repository)this.repositoryViewer.getInput();
    }

    public List<Object> getSelectedItems() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(((IStructuredSelection)this.repositoryViewer.getSelection()).toList());
        return l;
    }

    public void refresh() {
        this.repositoryViewer.refresh();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.repositoryViewer.removeSelectionChangedListener(listener);
    }
}

