/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui;

import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.dialogs.DialogShowDependencies;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class UpdateHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "bpm.repository.ui.commands.export";

    public UpdateHandler() {
        super.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryItem it;
        String modelXml;
        IRepositoryApi sock;
        IWorkbenchWindow window;
        block5: {
            window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            sock = Activator.getDefault().getDesignerActivator().getRepositoryConnection();
            Integer directoryItemId = Activator.getDefault().getDesignerActivator().getCurrentModelDirectoryItemId();
            modelXml = Activator.getDefault().getDesignerActivator().getCurrentModelXml();
            it = null;
            try {
                it = sock.getRepositoryService().getDirectoryItem(directoryItemId.intValue());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MessageDialog.openError((Shell)window.getShell(), (String)Messages.UpdateHandler_1, (String)Messages.UpdateHandler_2);
            }
            DialogShowDependencies dial = new DialogShowDependencies(window.getShell(), it, sock, DialogShowDependencies.UPDATE_TITLE);
            if (!dial.hasDependencies() || dial.open() == 0) break block5;
            return null;
        }
        try {
            sock.getRepositoryService().updateModel(it, modelXml);
            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.UpdateHandler_3, (String)(String.valueOf(Messages.UpdateHandler_4) + " " + it.getItemName() + " " + Messages.UpdateHandler_5 + Activator.getDefault().getDesignerActivator().getRepositoryContext().getRepository().getName()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.UpdateHandler_6, (String)(String.valueOf(Messages.UpdateHandler_7) + " " + it.getItemName() + " " + Messages.UpdateHandler_8 + ex.getMessage()));
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        boolean old = this.isEnabled();
        try {
            Object o = ((IEvaluationContext)evaluationContext).getVariable("bpm.repository.ui.connected");
            boolean enabled = "enabled".equals(o);
            o = ((IEvaluationContext)evaluationContext).getVariable("bpm.repository.ui.imported");
            boolean bl = enabled = enabled && "enabled".equals(o);
            if (old != enabled) {
                super.setBaseEnabled(enabled);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

