/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui;

import bpm.repository.ui.SessionSourceProvider;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Activator;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.versionning.VersionningManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.ISourceProviderService;

public class CheckinHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "bpm.repository.ui.commands.disconnection";

    public CheckinHandler() {
        super.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        String fileName = Activator.getDefault().getDesignerActivator().getCurrentModelFileName();
        Properties p = VersionningManager.getInstance().getCheckoutInfos(fileName);
        if (p == null) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.CheckinAction_0, (String)Messages.CheckinAction_1);
            return null;
        }
        p.getProperty("serverUrl");
        p.getProperty("username");
        p.getProperty("password");
        String directoryItemId = p.getProperty("directoryItemId");
        p.getProperty("groupId");
        IRepositoryApi sock = Activator.getDefault().getDesignerActivator().getRepositoryConnection();
        RepositoryItem repIt = null;
        try {
            repIt = sock.getRepositoryService().getDirectoryItem(Integer.parseInt(directoryItemId));
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.CheckinAction_7, (String)(String.valueOf(Messages.CheckinAction_8) + ex.getMessage()));
            return null;
        }
        String xml = Activator.getDefault().getDesignerActivator().getCurrentModelXml();
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            sock.getVersioningService().checkIn(repIt, "", (InputStream)bis);
            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.CheckinAction_10, (String)Messages.CheckinAction_11);
            VersionningManager.getInstance().performCheckin(fileName);
            ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
            SessionSourceProvider sessionProvider = (SessionSourceProvider)service.getSourceProvider("bpm.repository.ui.connected");
            sessionProvider.setCheckedIn(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.CheckinAction_12, (String)e.getMessage());
            VersionningManager.getInstance().saveChekout(fileName, sock, repIt);
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        boolean old = this.isEnabled();
        try {
            Object o = ((IEvaluationContext)evaluationContext).getVariable("bpm.repository.ui.checkedIn");
            boolean enabled = "enabled".equals(o);
            if (old != enabled) {
                super.setBaseEnabled(enabled);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

