/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.repository.ui;

import bpm.vanilla.designer.ui.common.ICheckoutReleaser;
import bpm.vanilla.designer.ui.common.IDesignerActivator;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import bpm.vanilla.repository.ui.Messages;
import bpm.vanilla.repository.ui.icons.IconsRegistry;
import bpm.vanilla.repository.ui.versionning.VersionningManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "bpm.vanilla.repository.ui";
    public static final String versionningFileName = "versionning.xml";
    public static final String SERVERS_FILENAME = "servers.xml";
    public static final String SERVERS_D4C_FILENAME = "servers_d4c.xml";
    private static Activator plugin;
    private HashMap<String, Integer> designerPluginsIdType = new HashMap();
    private IDesignerActivator<?> designerActivatorInstance;
    private PropertyChangeListener listener;

    public Activator() {
        this.designerPluginsIdType.put("bpm.metadata.client", 6);
        this.designerPluginsIdType.put("bpm.gateway.ui", 14);
        this.designerPluginsIdType.put("bpm.fasd.client", 0);
        this.designerPluginsIdType.put("bpm.fd.repository.ui", 1);
        this.designerPluginsIdType.put("bpm.workflow.ui", 13);
        this.designerPluginsIdType.put("bpm.hypervision.ui", 20);
        this.designerPluginsIdType.put("bpm.sqldesigner.ui", 23);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        String fileName = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "/resources/" + versionningFileName;
        VersionningManager.getInstance().load(fileName);
        if (this.getDesignerActivator() != null) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean release;
                    String filePath = evt.getPropertyName();
                    if (VersionningManager.getInstance().getCheckoutInfos(filePath) != null && (release = MessageDialog.openQuestion((Shell)Activator.this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.Activator_10, (String)Messages.Activator_11))) {
                        if (Activator.this.getDesignerActivator() instanceof ICheckoutReleaser) {
                            try {
                                ((ICheckoutReleaser)Activator.this.getDesignerActivator()).checkin(evt.getNewValue());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                MessageDialog.openError((Shell)Activator.this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.Activator_12, (String)(String.valueOf(Messages.Activator_13) + ex.getMessage()));
                            }
                        } else {
                            Activator.this.checkin(Activator.this.getWorkbench().getActiveWorkbenchWindow().getShell(), filePath);
                        }
                    }
                }
            };
            this.getDesignerActivator().addLoadModelListener(this.listener);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        Field[] fieldArray = IconsRegistry.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                reg.put((String)f.get(null), ImageDescriptor.createFromFile(Activator.class, (String)("icons/" + f.get(null))));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public IDesignerActivator<?> getDesignerActivator() {
        for (String s : this.designerPluginsIdType.keySet()) {
            Bundle bundle = Platform.getBundle((String)s);
            if (bundle == null) continue;
            String activatorClassName = (String)bundle.getHeaders().get("Bundle-Activator");
            try {
                Class activatorClass = bundle.loadClass(activatorClassName);
                Method method = activatorClass.getMethod("getDefault", new Class[0]);
                Object activatorInstance = method.invoke(null, new Object[0]);
                if (activatorInstance == null || !(activatorInstance instanceof IDesignerActivator)) continue;
                this.designerActivatorInstance = (IDesignerActivator)activatorInstance;
                break;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return this.designerActivatorInstance;
    }

    private void checkin(Shell shell, String fileName) {
        Properties p = VersionningManager.getInstance().getCheckoutInfos(fileName);
        if (p == null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.Activator_16, (String)Messages.Activator_17);
            VersionningManager.getInstance().performCheckin(fileName);
            return;
        }
        String directoryItemId = p.getProperty("directoryItemId");
        RemoteRepositoryApi sock = new RemoteRepositoryApi(this.getDesignerActivator().getRepositoryContext());
        RepositoryItem dirIt = null;
        try {
            dirIt = sock.getRepositoryService().getDirectoryItem(Integer.parseInt(directoryItemId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        InputStream modelStream = null;
        try {
            String xml = this.getDesignerActivator().getCurrentModelXml();
            if (xml == null) {
                modelStream = new FileInputStream(fileName);
            } else {
                modelStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            sock.getVersioningService().checkIn(dirIt, "", modelStream);
            MessageDialog.openInformation((Shell)shell, (String)Messages.Activator_26, (String)Messages.Activator_27);
            VersionningManager.getInstance().performCheckin(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)Messages.Activator_28, (String)e.getMessage());
            VersionningManager.getInstance().saveChekout(fileName, (IRepositoryApi)sock, dirIt);
        }
    }
}

