/*
 * Decompiled with CFR 0.152.
 */
package bpm.repository.ui;

import bpm.vanilla.platform.core.IRepositoryContext;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class SessionSourceProvider
extends AbstractSourceProvider {
    public static final String CONNECTION_STATE = "bpm.repository.ui.connected";
    public static final String IMPORTED_MODEL_STATE = "bpm.repository.ui.imported";
    public static final String CHECK_IN_STATE = "bpm.repository.ui.checkedIn";
    public static final String MODEL_OPENED_STATE = "bpm.repository.ui.modelOpened";
    public static final String enabled = "enabled";
    public static final String disabled = "disabled";
    private IRepositoryContext context;
    private Integer directoryItemId;
    private boolean checkedIn = false;
    private boolean modelOpened = false;

    public IRepositoryContext getContext() {
        return this.context;
    }

    public void setContext(IRepositoryContext context) {
        this.context = context;
        String currentState = (String)this.getCurrentState().get(CONNECTION_STATE);
        this.fireSourceChanged(0, CONNECTION_STATE, currentState);
    }

    public Integer getDirectoryItemId() {
        return this.directoryItemId;
    }

    public void setDirectoryItemId(Integer directoryItemId) {
        this.directoryItemId = directoryItemId;
        String currentState = (String)this.getCurrentState().get(IMPORTED_MODEL_STATE);
        this.fireSourceChanged(0, IMPORTED_MODEL_STATE, currentState);
    }

    public void dispose() {
    }

    public Map getCurrentState() {
        HashMap<String, String> currentState = new HashMap<String, String>(2);
        currentState.put(CONNECTION_STATE, this.context != null ? enabled : disabled);
        currentState.put(IMPORTED_MODEL_STATE, this.directoryItemId != null ? enabled : disabled);
        currentState.put(CHECK_IN_STATE, this.checkedIn ? enabled : disabled);
        currentState.put(MODEL_OPENED_STATE, this.modelOpened ? enabled : disabled);
        return currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{CONNECTION_STATE, IMPORTED_MODEL_STATE, CHECK_IN_STATE, MODEL_OPENED_STATE};
    }

    public boolean isCheckedIn() {
        return this.checkedIn;
    }

    public void setCheckedIn(boolean checkedIn) {
        this.checkedIn = checkedIn;
        String currentState = (String)this.getCurrentState().get(CHECK_IN_STATE);
        this.fireSourceChanged(0, CHECK_IN_STATE, currentState);
    }

    public boolean isModelOpened() {
        return this.modelOpened;
    }

    public void setModelOpened(boolean modelOpened) {
        this.modelOpened = modelOpened;
        String currentState = (String)this.getCurrentState().get(MODEL_OPENED_STATE);
        this.fireSourceChanged(0, MODEL_OPENED_STATE, currentState);
    }
}

