/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.ui.impl.datasource;

import bpm.excel.oda.ui.impl.datasource.ConnectionComposite;
import bpm.vanilla.platform.core.utils.MD5Helper;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ExcelDataSourcePage
extends DataSourceWizardPage {
    private ConnectionComposite connectionComposite;
    private Properties prop;

    public ExcelDataSourcePage(String pageName) {
        super(pageName);
    }

    public ExcelDataSourcePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public Properties collectCustomProperties() {
        this.prop = new Properties();
        if (this.connectionComposite != null) {
            this.prop.put("repository.user", this.connectionComposite.getUsername());
            this.prop.put("repository.password", MD5Helper.encode((String)this.connectionComposite.getPassword()));
            this.prop.put("repository.id", String.valueOf(this.connectionComposite.getRepositoryId()));
            this.prop.put("vanilla.group.id", String.valueOf(this.connectionComposite.getGroupId()));
            if (this.connectionComposite.getDirectoryItem() != null) {
                this.prop.put("repository.item.id", String.valueOf(this.connectionComposite.getDirectoryItem().getId()));
            }
        }
        return this.prop;
    }

    public void createPageCustomControl(Composite parent) {
        this.connectionComposite = new ConnectionComposite(parent, 0, this);
        this.connectionComposite.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                ExcelDataSourcePage.this.setPingButtonEnabled((Boolean)event.data);
            }
        });
    }

    public void setInitialProperties(Properties dataSourceProps) {
        this.prop = dataSourceProps;
    }

    public void setPingButton(boolean value) {
        this.setPingButtonEnabled(value);
    }

    public boolean isPageComplete() {
        return this.connectionComposite.isPageComplete();
    }

    public void updateButtons() {
        this.getContainer().updateButtons();
    }
}

