/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.ui.impl.datasource;

import bpm.excel.oda.ui.impl.datasource.ExcelDataSourcePage;
import bpm.vanilla.oda.commons.trees.TreeContentProvider;
import bpm.vanilla.oda.commons.trees.TreeDirectory;
import bpm.vanilla.oda.commons.trees.TreeItem;
import bpm.vanilla.oda.commons.trees.TreeLabelProvider;
import bpm.vanilla.oda.commons.trees.TreeObject;
import bpm.vanilla.oda.commons.trees.TreeParent;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.beans.ged.ComProperties;
import bpm.vanilla.platform.core.beans.ged.GedDocument;
import bpm.vanilla.platform.core.beans.ged.IComProperties;
import bpm.vanilla.platform.core.beans.ged.constant.RuntimeFields;
import bpm.vanilla.platform.core.components.ged.GedIndexRuntimeConfig;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.remote.impl.components.RemoteGedComponent;
import bpm.vanilla.platform.core.repository.IRepository;
import bpm.vanilla.platform.core.repository.RepositoryDirectory;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionComposite
extends Composite {
    private Text login;
    private Text password;
    private Text vanillaUrl;
    private Text path;
    private TreeViewer viewer;
    private ComboViewer groups;
    private ComboViewer repositories;
    private IRepositoryApi repSocket;
    private IRepository repository;
    private RepositoryItem directoryItem;
    private ExcelDataSourcePage page;
    private IVanillaAPI vanillaApi;
    private List<Group> availableGroups;
    private List<Repository> availableRepositories;
    private TreeParent root;

    public ConnectionComposite(Composite parent, int style, ExcelDataSourcePage page) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        this.page = page;
        this.buildContent();
        this.fillData(null, true);
    }

    private void buildContent() {
        Label l0 = new Label((Composite)this, 0);
        l0.setLayoutData((Object)new GridData(1, 2, false, false));
        l0.setText("File path");
        this.path = new Text((Composite)this, 2048);
        this.path.setLayoutData((Object)new GridData(4, 4, true, true));
        Button btnGetFile = new Button((Composite)this, 8);
        btnGetFile.setText("...");
        btnGetFile.setLayoutData((Object)new GridData(2, 2, false, false));
        btnGetFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ConnectionComposite.this.getShell());
                fd.setFilterExtensions(new String[]{"*.xls"});
                ConnectionComposite.this.path.setText(fd.open());
            }
        });
        Label l3 = new Label((Composite)this, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText("Vanilla Url");
        this.vanillaUrl = new Text((Composite)this, 2048);
        this.vanillaUrl.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label l = new Label((Composite)this, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("User name");
        this.login = new Text((Composite)this, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label l2 = new Label((Composite)this, 0);
        l2.setLayoutData((Object)new GridData(1, 2, false, false));
        l2.setText("Password");
        this.password = new Text((Composite)this, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button btnInfos = new Button((Composite)this, 8);
        btnInfos.setText("Load User's Informations");
        btnInfos.setLayoutData((Object)new GridData(2, 2, true, false, 3, 1));
        btnInfos.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ConnectionComposite.this.fillInfos(false);
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                    MessageDialog.openError((Shell)ConnectionComposite.this.getShell(), (String)"Load Groups", (String)("Error while loading groups;\r\n" + _e.getMessage()));
                }
            }
        });
        Label l7 = new Label((Composite)this, 0);
        l7.setLayoutData((Object)new GridData(1, 2, false, false));
        l7.setText("Repository Name");
        this.repositories = new ComboViewer((Composite)this, 8);
        this.repositories.getCombo().setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        this.repositories.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Repository) {
                    return ((Repository)element).getName();
                }
                return super.getText(element);
            }
        });
        this.repositories.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List rep = (List)inputElement;
                return rep.toArray(new Repository[rep.size()]);
            }
        });
        Label l8 = new Label((Composite)this, 0);
        l8.setLayoutData((Object)new GridData(1, 2, false, false));
        l8.setText("Group Name");
        this.groups = new ComboViewer((Composite)this, 8);
        this.groups.getCombo().setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        this.groups.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Group) {
                    return ((Group)element).getName();
                }
                return super.getText(element);
            }
        });
        this.groups.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List groups = (List)inputElement;
                return groups.toArray(new Group[groups.size()]);
            }
        });
        Composite btn = new Composite((Composite)this, 0);
        btn.setLayout((Layout)new GridLayout(2, false));
        btn.setLayoutData((Object)new GridData(2, 2, false, false, 3, 1));
        Button conRep = new Button(btn, 8);
        conRep.setText("Connect to Repository");
        conRep.setLayoutData((Object)new GridData(2, 2, true, false));
        conRep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = ((IStructuredSelection)ConnectionComposite.this.groups.getSelection()).getFirstElement();
                if (o == null) {
                    MessageDialog.openWarning((Shell)ConnectionComposite.this.getShell(), (String)"Group Selection", (String)"Please select a group before to connect");
                    return;
                }
                Object _o = ((IStructuredSelection)ConnectionComposite.this.repositories.getSelection()).getFirstElement();
                if (_o == null) {
                    MessageDialog.openWarning((Shell)ConnectionComposite.this.getShell(), (String)"Repository Selection", (String)"Please select a reppository to connect");
                    return;
                }
                BaseVanillaContext vanillaContext = new BaseVanillaContext(ConnectionComposite.this.vanillaApi.getVanillaUrl(), ConnectionComposite.this.login.getText(), ConnectionComposite.this.password.getText());
                BaseRepositoryContext ctx = new BaseRepositoryContext((IVanillaContext)vanillaContext, (Group)o, (Repository)_o);
                ConnectionComposite.this.repSocket = (IRepositoryApi)new RemoteRepositoryApi((IRepositoryContext)ctx);
                try {
                    ConnectionComposite.this.createTreeContent();
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)ConnectionComposite.this.getShell(), (String)"Connection Error", (String)e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        Button publish = new Button(btn, 8);
        publish.setText("Publish file on repository");
        publish.setLayoutData((Object)new GridData(2, 2, true, false));
        publish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionComposite.this.path.getText() == null || ConnectionComposite.this.path.getText().equalsIgnoreCase("")) {
                    MessageDialog.openWarning((Shell)ConnectionComposite.this.getShell(), (String)"File Selection", (String)"You have to select a file");
                    return;
                }
                if (ConnectionComposite.this.viewer.getSelection().isEmpty()) {
                    MessageDialog.openWarning((Shell)ConnectionComposite.this.getShell(), (String)"Directory Selection", (String)"You have to select a directory");
                    return;
                }
                Object selected = ((IStructuredSelection)ConnectionComposite.this.viewer.getSelection()).getFirstElement();
                if (!(selected instanceof TreeDirectory)) {
                    return;
                }
                String p = ConnectionComposite.this.path.getText();
                String name = p.substring(p.lastIndexOf(File.separator) + 1);
                Group cfr_ignored_0 = (Group)((IStructuredSelection)ConnectionComposite.this.groups.getSelection()).getFirstElement();
                try {
                    ConnectionComposite.this.repSocket.getRepositoryService().addExternalDocumentWithDisplay(((TreeDirectory)selected).getDirectory(), name, "", "", "", (InputStream)new FileInputStream(new File(p)), false, ConnectionComposite.this.login.getText());
                    String format = p.substring(p.lastIndexOf(".") + 1, p.length());
                    ArrayList<Integer> groupIds = new ArrayList<Integer>();
                    groupIds.add(ConnectionComposite.this.repSocket.getContext().getGroup().getId());
                    RemoteGedComponent gedComp = new RemoteGedComponent(ConnectionComposite.this.vanillaApi.getVanillaContext());
                    GedDocument doc = new GedDocument();
                    doc.setDirectoryId(Integer.valueOf(0));
                    doc.setName(name);
                    doc.setCreationDate(new Date());
                    int userId = ConnectionComposite.this.vanillaApi.getVanillaSecurityManager().getUserByLogin(ConnectionComposite.this.vanillaApi.getVanillaContext().getLogin()).getId();
                    doc.setCreatedBy(userId);
                    doc.setMdmAttached(false);
                    ComProperties com = new ComProperties();
                    com.setSimpleProperty(RuntimeFields.TITLE.getName(), name);
                    GedIndexRuntimeConfig config = new GedIndexRuntimeConfig((IComProperties)com, userId, -1, groupIds, ConnectionComposite.this.repSocket.getContext().getRepository().getId(), format, null, -1);
                    config.setMdmAttached(true);
                    int id = gedComp.index(config, (InputStream)new FileInputStream(new File(p)));
                    for (Integer groupId : groupIds) {
                        gedComp.addAccess(id, groupId.intValue(), ConnectionComposite.this.repSocket.getContext().getRepository().getId());
                    }
                    MessageDialog.openInformation((Shell)ConnectionComposite.this.getShell(), (String)"Publish file", (String)"The file has been publish successfully");
                    ConnectionComposite.this.createTreeContent();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.viewer = new TreeViewer((Composite)this, 2816);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ConnectionComposite.this.viewer.getSelection().isEmpty()) {
                    ConnectionComposite.this.directoryItem = null;
                    if (ConnectionComposite.this.page != null) {
                        ConnectionComposite.this.page.setPingButton(false);
                    }
                    return;
                }
                Object selected = ((IStructuredSelection)ConnectionComposite.this.viewer.getSelection()).getFirstElement();
                if (selected instanceof TreeItem) {
                    ConnectionComposite.this.directoryItem = ((TreeItem)selected).getItem();
                    if (ConnectionComposite.this.page != null) {
                        ConnectionComposite.this.page.setPingButton(true);
                    }
                } else {
                    ConnectionComposite.this.directoryItem = null;
                    if (ConnectionComposite.this.page != null) {
                        ConnectionComposite.this.page.setPingButton(false);
                    }
                }
                ConnectionComposite.this.page.updateButtons();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    private void fillInfos(boolean isTimeOut) throws Exception {
        String vanillaurl = this.vanillaUrl.getText();
        if (vanillaurl == null || vanillaurl.equalsIgnoreCase("")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Vanilla Server", (String)"Vanilla Security Server's url is not set. \n Use Window -> Preference to define a default value");
            return;
        }
        this.vanillaApi = new RemoteVanillaPlatform(vanillaurl, this.login.getText(), this.password.getText());
        User u = this.vanillaApi.getVanillaSecurityManager().authentify("", this.login.getText(), this.password.getText(), isTimeOut);
        this.availableRepositories = this.vanillaApi.getVanillaRepositoryManager().getUserRepositories(u.getLogin());
        this.availableGroups = this.vanillaApi.getVanillaSecurityManager().getGroups(u);
        this.repositories.setInput(this.availableRepositories);
        this.groups.setInput(this.availableGroups);
    }

    public void fillData(Properties properties, boolean isTimeOut) {
        if (properties != null) {
            this.password.setText(properties.getProperty("repository.password"));
            this.login.setText(properties.getProperty("repository.user"));
            try {
                this.fillInfos(isTimeOut);
                Group g = this.vanillaApi.getVanillaSecurityManager().getGroupById(new Integer(properties.getProperty("vanilla.group.id")).intValue());
                for (Group _g : this.availableGroups) {
                    if (g.getId() != _g.getId()) continue;
                    this.groups.setSelection((ISelection)new StructuredSelection((Object)_g));
                }
                Repository rep = this.vanillaApi.getVanillaRepositoryManager().getRepositoryById(new Integer(properties.getProperty("repository.id")).intValue());
                for (Repository _rep : this.availableRepositories) {
                    if (rep.getId() != _rep.getId()) continue;
                    this.repositories.setSelection((ISelection)new StructuredSelection((Object)_rep));
                }
                BaseVanillaContext vanillaContext = new BaseVanillaContext(this.vanillaApi.getVanillaUrl(), this.login.getText(), this.password.getText());
                BaseRepositoryContext ctx = new BaseRepositoryContext((IVanillaContext)vanillaContext, g, rep);
                this.repSocket = new RemoteRepositoryApi((IRepositoryContext)ctx);
                try {
                    this.createTreeContent();
                    this.directoryItem = this.repository.getItem(new Integer(properties.getProperty("repository.item.id")).intValue());
                    this.findTreeItem(this.root);
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Connection Error", (String)e1.getMessage());
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void findTreeItem(TreeParent _root) {
        for (TreeObject o : _root.getChildren()) {
            if (o instanceof TreeItem && ((TreeItem)o).getItem().getId() == this.directoryItem.getId()) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)((TreeItem)o)));
                continue;
            }
            if (!(o instanceof TreeDirectory)) continue;
            this.findTreeItem((TreeParent)o);
        }
    }

    private void createTreeContent() throws Exception {
        this.repository = new bpm.vanilla.platform.core.repository.Repository(this.repSocket, 17);
        List list = this.repository.getRootDirectories();
        this.root = new TreeParent("root");
        StringBuffer buf = new StringBuffer();
        for (RepositoryDirectory d : list) {
            TreeDirectory tp = new TreeDirectory(d);
            this.root.addChild((TreeObject)tp);
            this.buildChilds(tp);
            try {
                for (RepositoryItem di : this.repository.getItems(d)) {
                    TreeItem ti = new TreeItem(di);
                    tp.addChild((TreeObject)ti);
                }
            }
            catch (Exception ex) {
                buf.append(" - Problem on " + d.getName() + " content : " + ex.getMessage() + "\n");
            }
        }
        this.viewer.setInput((Object)this.root);
        if (buf.toString().length() > 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Browsing", (String)("Some error occured when browsing the Repository : \n" + buf.toString()));
        }
    }

    private void buildChilds(TreeDirectory parent) {
        RepositoryDirectory dir = parent.getDirectory();
        try {
            for (RepositoryDirectory d : this.repository.getChildDirectories(dir)) {
                TreeDirectory td = new TreeDirectory(d);
                parent.addChild((TreeObject)td);
                for (RepositoryItem di : this.repository.getItems(d)) {
                    TreeItem ti = new TreeItem(di);
                    td.addChild((TreeObject)ti);
                }
                this.buildChilds(td);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getRepositoryId() {
        Object o = ((IStructuredSelection)this.repositories.getSelection()).getFirstElement();
        return ((Repository)o).getId();
    }

    public String getUsername() {
        return this.login.getText();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public RepositoryItem getDirectoryItem() {
        return this.directoryItem;
    }

    public int getGroupId() {
        Object o = ((IStructuredSelection)this.groups.getSelection()).getFirstElement();
        return ((Group)o).getId();
    }

    public boolean isPageComplete() {
        return this.directoryItem != null;
    }
}

