/*
 * Decompiled with CFR 0.152.
 */
package bpm.excel.oda.ui.impl;

import bpm.excel.oda.runtime.impl.Connection;
import bpm.excel.oda.runtime.impl.ConnectionManager;
import bpm.excel.oda.ui.impl.CellComparator;
import bpm.vanilla.oda.commons.Activator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ExcelDataSetWizardPage
extends DataSetWizardPage {
    private static final CellComparator cellComparator = new CellComparator();
    private static String DEFAULT_MESSAGE = "Define the query text for the data set";
    private PGroup groupeCols;
    private PGroup groupSheets;
    private ComboViewer comboSheets;
    private Button btnSkip;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddAll;
    private Button btnRemoveAll;
    private Button btnAddParam;
    private Button btnDelParam;
    private ListViewer listCol;
    private TableViewer viewerColSelected;
    private TableViewer viewerParameters;
    private Table tableParameters;
    private IStructuredSelection selectionParam;
    private List<Cell> availableCells = new ArrayList<Cell>();
    private List<Cell> selectedCells = new ArrayList<Cell>();
    private Sheet selectedSheet;
    private Workbook workbookin;

    public ExcelDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public ExcelDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        Composite inCompo = new Composite(parent, 0);
        inCompo.setLayout((Layout)new GridLayout(1, false));
        this.setControl(this.createPageControl(inCompo));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        this.setMessage("Choose a Sheet, and apply if needed filters.");
        this.setPageComplete(false);
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.setLayout((Layout)new GridLayout(2, false));
        this.groupSheets = new PGroup(parent, 65536);
        this.groupSheets.setText("Sheet Selection");
        this.groupSheets.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        this.groupSheets.setLayout((Layout)new GridLayout(3, false));
        this.groupSheets.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/application_view_list.png"));
        Label lbl = new Label((Composite)this.groupSheets, 0);
        lbl.setText("Choose a Sheet:");
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.comboSheets = new ComboViewer((Composite)this.groupSheets, 12);
        this.comboSheets.getCombo().setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.comboSheets.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Object[] currentElement = (Sheet[])inputElement;
                return currentElement;
            }
        });
        this.comboSheets.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Sheet)element).getName();
            }
        });
        this.comboSheets.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExcelDataSetWizardPage.this.availableCells = new ArrayList();
                ExcelDataSetWizardPage.this.selectedCells = new ArrayList();
                ExcelDataSetWizardPage.this.viewerColSelected.setInput((Object)ExcelDataSetWizardPage.this.selectedCells);
                ExcelDataSetWizardPage.this.listCol.setInput((Object)ExcelDataSetWizardPage.this.availableCells);
                IStructuredSelection selection = (IStructuredSelection)ExcelDataSetWizardPage.this.comboSheets.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object o = selection.getFirstElement();
                ExcelDataSetWizardPage.this.selectedSheet = (Sheet)o;
                int nbCol = ExcelDataSetWizardPage.this.selectedSheet.getColumns();
                int i = 0;
                while (i < nbCol) {
                    if (!ExcelDataSetWizardPage.this.selectedSheet.getCell(i, 0).getContents().equalsIgnoreCase("")) {
                        ExcelDataSetWizardPage.this.availableCells.add(ExcelDataSetWizardPage.this.selectedSheet.getCell(i, 0));
                    }
                    ++i;
                }
                ExcelDataSetWizardPage.this.listCol.setInput((Object)ExcelDataSetWizardPage.this.availableCells);
            }
        });
        lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.groupeCols = new PGroup(parent, 65536);
        this.groupeCols.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        this.groupeCols.setLayout((Layout)new GridLayout(2, false));
        this.groupeCols.setText("Column's Options");
        this.groupeCols.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/column.png"));
        lbl = new Label((Composite)this.groupeCols, 0);
        lbl.setText("Select Columns to display themself. Rename them if needed to edit the \" Column's Label\" in the table.");
        lbl.setLayoutData((Object)new GridData(4, 4, false, true, 2, 2));
        Composite groupListColumn = new Composite((Composite)this.groupeCols, 2048);
        groupListColumn.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        groupListColumn.setLayout((Layout)new GridLayout(2, false));
        this.listCol = new ListViewer(groupListColumn, 2058);
        this.listCol.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.listCol.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }
        });
        this.listCol.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Cell)element).getContents();
            }
        });
        this.btnAdd = new Button(groupListColumn, 8);
        this.btnAdd.setToolTipText("Add a column");
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAdd.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/add.png"));
        this.btnRemove = new Button(groupListColumn, 8);
        this.btnRemove.setToolTipText("Remove a column");
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemove.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/delete.png"));
        this.btnAddAll = new Button(groupListColumn, 8);
        this.btnAddAll.setToolTipText("Add All columns");
        this.btnAddAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAddAll.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/table_add.png"));
        this.btnRemoveAll = new Button(groupListColumn, 8);
        this.btnRemoveAll.setToolTipText("Remove All columns");
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemoveAll.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/table_delete.png"));
        Composite groupListSelected = new Composite((Composite)this.groupeCols, 0);
        groupListSelected.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        groupListSelected.setLayout((Layout)new GridLayout(1, false));
        this.viewerColSelected = new TableViewer(groupListSelected, 68354);
        this.viewerColSelected.getTable().setLayoutData((Object)new GridData(4, 4, false, true, 1, 5));
        this.viewerColSelected.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList currentElement = (ArrayList)inputElement;
                return currentElement.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText("Column's Name");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Cell)element).getContents();
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ui/icons/table_go.png");
            }
        });
        column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText("Column's label");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Cell)element).getContents();
            }
        });
        int i = 0;
        int n = this.viewerColSelected.getTable().getColumnCount();
        while (i < n) {
            this.viewerColSelected.getTable().getColumn(i).setWidth(145);
            ++i;
        }
        this.viewerColSelected.getTable().setHeaderVisible(true);
        this.viewerColSelected.getTable().setLinesVisible(true);
        this.viewerColSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)event.getSelection();
            }
        });
        this.initListenersBtnTool();
        return parent;
    }

    private void initListenersBtnTool() {
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExcelDataSetWizardPage.this.listCol.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                for (Cell cell : selection) {
                    System.out.println(cell.getColumn());
                    ExcelDataSetWizardPage.this.selectedCells.add(cell);
                    ExcelDataSetWizardPage.this.availableCells.remove(cell);
                }
                Collections.sort(ExcelDataSetWizardPage.this.selectedCells, cellComparator);
                ExcelDataSetWizardPage.this.listCol.setInput((Object)ExcelDataSetWizardPage.this.availableCells);
                ExcelDataSetWizardPage.this.viewerColSelected.setInput((Object)ExcelDataSetWizardPage.this.selectedCells);
                ExcelDataSetWizardPage.this.setPageComplete(true);
            }
        });
        this.btnAddAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExcelDataSetWizardPage.this.selectedCells.addAll(ExcelDataSetWizardPage.this.availableCells);
                ExcelDataSetWizardPage.this.availableCells = new ArrayList();
                ExcelDataSetWizardPage.this.listCol.setInput((Object)ExcelDataSetWizardPage.this.availableCells);
                Collections.sort(ExcelDataSetWizardPage.this.selectedCells, cellComparator);
                ExcelDataSetWizardPage.this.viewerColSelected.setInput((Object)ExcelDataSetWizardPage.this.selectedCells);
                ExcelDataSetWizardPage.this.setPageComplete(true);
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExcelDataSetWizardPage.this.viewerColSelected.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                for (Cell c : selection) {
                    ExcelDataSetWizardPage.this.selectedCells.remove(c);
                    ExcelDataSetWizardPage.this.availableCells.add(c);
                }
                Collections.sort(ExcelDataSetWizardPage.this.selectedCells, cellComparator);
                Collections.sort(ExcelDataSetWizardPage.this.availableCells, cellComparator);
                ExcelDataSetWizardPage.this.listCol.setInput((Object)ExcelDataSetWizardPage.this.availableCells);
                ExcelDataSetWizardPage.this.viewerColSelected.setInput((Object)ExcelDataSetWizardPage.this.selectedCells);
                ExcelDataSetWizardPage.this.setPageComplete(!ExcelDataSetWizardPage.this.selectedCells.isEmpty());
            }
        });
        this.btnRemoveAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExcelDataSetWizardPage.this.availableCells.addAll(ExcelDataSetWizardPage.this.selectedCells);
                ExcelDataSetWizardPage.this.selectedCells = new ArrayList();
                Collections.sort(ExcelDataSetWizardPage.this.availableCells, cellComparator);
                ExcelDataSetWizardPage.this.listCol.setInput((Object)ExcelDataSetWizardPage.this.availableCells);
                ExcelDataSetWizardPage.this.viewerColSelected.setInput((Object)ExcelDataSetWizardPage.this.selectedCells);
                ExcelDataSetWizardPage.this.setPageComplete(false);
            }
        });
    }

    private void initializeControl() {
        Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        try {
            IConnection conn = ConnectionManager.getConnection((Properties)connProps, (String)this.getInitializationDesign().getDataSourceDesign().getOdaExtensionDataSourceId());
            this.fillDatas((Connection)conn);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
            return;
        }
        try {
            this.initSelection(dataSetDesign);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void initSelection(DataSetDesign dataSetDesign) throws DocumentException {
        String queryText = dataSetDesign.getQueryText();
        Document doc = DocumentHelper.parseText((String)queryText);
        Element root = doc.getRootElement();
        String sheetName = root.element("sheet").getText();
        this.selectedSheet = this.workbookin.getSheet(sheetName);
        this.comboSheets.setSelection((ISelection)new StructuredSelection((Object)this.selectedSheet));
        Element cells = root.element("cells");
        for (Object o : cells.elements("cell")) {
            Element e = (Element)o;
            Cell c = this.selectedSheet.getCell(new Integer(e.getStringValue()).intValue(), 0);
            this.availableCells.remove(c);
            this.selectedCells.add(c);
        }
        Collections.sort(this.availableCells, cellComparator);
        Collections.sort(this.selectedCells, cellComparator);
        this.listCol.setInput(this.availableCells);
        this.viewerColSelected.setInput(this.selectedCells);
        this.setPageComplete(!this.selectedCells.isEmpty());
    }

    private void fillDatas(Connection conn) throws BiffException, IOException {
        String path = conn.getTemporaryFile();
        FileInputStream is = new FileInputStream(path);
        this.workbookin = Workbook.getWorkbook((InputStream)is);
        ((InputStream)is).close();
        this.comboSheets.setInput((Object)this.workbookin.getSheets());
    }

    private String getQueryText() {
        Element root = DocumentHelper.createElement((String)"bpm.excel.oda.query");
        root.addElement("sheet").setText(this.selectedSheet.getName());
        Element cells = root.addElement("cells");
        for (Cell c : this.selectedCells) {
            cells.addElement("cell").setText(String.valueOf(c.getColumn()));
        }
        return root.asXML();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null) {
            return design;
        }
        if (!this.hasValidData()) {
            return null;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = this.getQueryText() != null && this.getQueryText().trim().length() > 0;
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage("Requires input value.", 3);
        }
        this.setPageComplete(isValid);
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection conn = null;
            try {
                try {
                    Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    conn = ConnectionManager.getConnection((Properties)connProps, (String)dataSetDesign.getOdaExtensionDataSourceId());
                    this.updateDesign(dataSetDesign, conn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(dataSetDesign.getOdaExtensionDataSetId());
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

