/*
 * Decompiled with CFR 0.152.
 */
package bpm.fwr.oda.runtime.impl;

import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import bpm.fwr.oda.runtime.ConnectionPool;
import bpm.fwr.oda.runtime.impl.Connection;
import bpm.metadata.layer.business.IBusinessModel;
import bpm.metadata.layer.business.IBusinessPackage;
import bpm.metadata.layer.physical.sql.SQLConnection;
import bpm.vanilla.platform.core.beans.Group;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Query
extends bpm.metadata.birt.oda.runtime.impl.Query {
    protected Document document;
    private String username;
    private String password;
    private String repositoryUrl;
    private String groupName;
    private String businessModel;
    private String businessPackage;
    private String connectionName;
    private String dataSourceName;
    private Integer directoryItemId;
    private String encrypted = "false";
    private VanillaJdbcConnection jdbcConnection;

    public Query(bpm.metadata.birt.oda.runtime.impl.Connection fmdtConnection, VanillaPreparedStatement jdbcStatement, IBusinessPackage pack, String connectionName, Group group) {
        super(fmdtConnection, jdbcStatement, pack, connectionName, group);
    }

    public void prepare(String queryText) throws OdaException {
        String fmdtquerytext;
        block22: {
            try {
                this.document = DocumentHelper.parseText((String)queryText);
            }
            catch (DocumentException e1) {
                e1.printStackTrace();
            }
            for (Element e : this.document.getRootElement().elements("datasource")) {
                Element d;
                if (e.element("model") != null && (d = e.element("model")) != null) {
                    this.businessModel = d.getStringValue();
                }
                if (e.element("package") != null && (d = e.element("package")) != null) {
                    this.businessPackage = d.getStringValue();
                }
                if (e.element("connection") != null && (d = e.element("connection")) != null) {
                    this.connectionName = d.getStringValue();
                }
                if (e.element("group") != null && (d = e.element("group")) != null) {
                    this.groupName = d.getStringValue();
                }
                if (e.element("itemid") != null && (d = e.element("itemid")) != null) {
                    this.directoryItemId = Integer.parseInt(d.getStringValue());
                }
                if (e.element("name") != null && (d = e.element("name")) != null) {
                    this.dataSourceName = d.getStringValue();
                }
                if (e.element("password") != null && (d = e.element("password")) != null) {
                    this.password = d.getStringValue();
                }
                if (e.element("isencrypted") != null && (d = e.element("isencrypted")) != null) {
                    this.encrypted = d.getStringValue();
                }
                if (e.element("url") != null && (d = e.element("url")) != null) {
                    this.repositoryUrl = d.getStringValue();
                }
                if (e.element("user") == null || (d = e.element("user")) == null) continue;
                this.username = d.getStringValue();
            }
            Element qE = this.document.getRootElement().element("freeMetaDataQuery");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            fmdtquerytext = null;
            try {
                XMLWriter writer = new XMLWriter((OutputStream)bos, OutputFormat.createPrettyPrint());
                writer.write(qE);
                writer.close();
                fmdtquerytext = bos.toString("UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Properties fmdtProp = new Properties();
            fmdtProp.put("BUSINESS_MODEL", this.businessModel);
            fmdtProp.put("BUSINESS_PACKAGE", this.businessPackage);
            fmdtProp.put("CONNECTION_NAME", "Default");
            fmdtProp.put("DIRECTORY_ITEM_ID", "" + this.directoryItemId);
            fmdtProp.put("GROUP_NAME", this.groupName);
            fmdtProp.put("IS_ENCRYPTED", this.encrypted);
            fmdtProp.put("PASSWORD", this.password);
            fmdtProp.put("URL", this.repositoryUrl);
            fmdtProp.put("USER", this.username);
            try {
                for (IBusinessModel m : ConnectionPool.getConnection(fmdtProp)) {
                    if (!m.getName().equals(this.businessModel)) continue;
                    for (IBusinessPackage p : m.getBusinessPackages(this.groupName)) {
                        if (!p.getName().equals(this.businessPackage)) continue;
                        this.fmdtPackage = p;
                        break block22;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OdaException("Unable to rebuild FMDT model from xml\n", e.getMessage());
            }
        }
        try {
            this.jdbcConnection = ((SQLConnection)this.fmdtPackage.getConnection(this.groupName, this.connectionName)).getJdbcConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException((Throwable)e);
        }
        ((Connection)this.getConnection()).initFmdtConnection(this.connectionName, this.fmdtPackage, this.groupName, this.jdbcConnection, this.repositoryUrl, this.username, this.password);
        try {
            VanillaPreparedStatement jdbcStatement = this.jdbcConnection.createStatement();
            super.setJdbcStatement(jdbcStatement);
            super.prepare(fmdtquerytext);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

