/*
 * Decompiled with CFR 0.152.
 */
package bpm.fwr.oda.runtime.impl;

import bpm.fwr.api.beans.dataset.Column;
import bpm.fwr.api.beans.dataset.DataSet;
import bpm.fwr.api.beans.dataset.DataSource;
import bpm.metadata.layer.business.GrantException;
import bpm.metadata.layer.business.IBusinessModel;
import bpm.metadata.layer.business.IBusinessPackage;
import bpm.metadata.layer.business.IBusinessTable;
import bpm.metadata.layer.logical.IDataStreamElement;
import bpm.metadata.query.IQuery;
import bpm.metadata.query.QuerySql;
import bpm.metadata.query.SqlQueryBuilder;
import bpm.vanilla.platform.core.IRepositoryApi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DatasHelper {
    private static DatasHelper instance;

    private DatasHelper() {
    }

    public static DatasHelper getInstance() {
        if (instance == null) {
            instance = new DatasHelper();
        }
        return instance;
    }

    public IBusinessTable lookUnder(IBusinessTable table, String tableName, String groupName) {
        IBusinessTable res = null;
        List childs = table.getChilds(groupName);
        for (Object o : childs) {
            IBusinessTable t = (IBusinessTable)o;
            if (t.getName().equalsIgnoreCase(tableName)) {
                res = t;
            }
            if (res != null) continue;
            return this.lookUnder(t, tableName, groupName);
        }
        return res;
    }

    public String buildQuery(DataSet ds, IRepositoryApi sock) {
        IBusinessPackage pckg = null;
        try {
            IBusinessModel model = bpm.fwr.api.birt.DatasHelper.getSelectedModel((IRepositoryApi)sock, (DataSource)ds.getDatasource());
            pckg = model.getBusinessPackage(ds.getDatasource().getBusinessPackage(), ds.getDatasource().getGroup());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List columns = ds.getColumns();
        ArrayList<IDataStreamElement> iDataStreamElements = new ArrayList<IDataStreamElement>();
        for (Column col : columns) {
            if (col.isCalculated()) continue;
            String tName = col.getBusinessTableParent();
            IBusinessTable t = pckg.getBusinessTable(ds.getDatasource().getGroup(), tName);
            if (t == null) {
                List tables = pckg.getBusinessTables(ds.getDatasource().getGroup());
                Iterator it = tables.iterator();
                while (it.hasNext() && t == null) {
                    IBusinessTable table = (IBusinessTable)it.next();
                    t = this.lookUnder(table, tName, ds.getDatasource().getGroup());
                }
            }
            try {
                IDataStreamElement d = t.getColumn(ds.getDatasource().getGroup(), col.getBasicName());
                iDataStreamElements.add(d);
            }
            catch (GrantException e) {
                e.printStackTrace();
            }
        }
        ArrayList filters = new ArrayList();
        filters = null;
        ArrayList prompts = new ArrayList();
        prompts = null;
        IQuery iq = SqlQueryBuilder.getQuery((String)ds.getDatasource().getGroup(), iDataStreamElements, null, null, null, filters, prompts);
        if (ds.getDatasource().getConnectionName() == null || "Default".equalsIgnoreCase(ds.getDatasource().getConnectionName()) || ds.getDatasource().getConnectionName().trim().equalsIgnoreCase("")) {
            ds.getDatasource().setConnectionName((String)pckg.getConnectionsNames(ds.getDatasource().getGroup()).get(0));
        }
        return ((QuerySql)iq).getXml();
    }
}

