/*
 * Decompiled with CFR 0.152.
 */
package bpm.fwr.oda.runtime.impl;

import bpm.fwr.api.beans.FWRReport;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Properties;

public class ConnectionManager {
    private static HashMap<Properties, FWRReport> loadFWRReport = new HashMap();

    public static FWRReport getFWRReport(Properties connProps) throws Exception {
        for (Properties key : loadFWRReport.keySet()) {
            FWRReport r;
            if (!key.equals(connProps) || (r = loadFWRReport.get(key)) == null) continue;
            return r;
        }
        connProps.getProperty("REPOSITORY_URL");
        connProps.getProperty("USER");
        connProps.getProperty("PASSWORD");
        Integer.parseInt(connProps.getProperty("GROUP_ID"));
        int directoryItemId = Integer.parseInt(connProps.getProperty("FWREPORT_ID"));
        IRepositoryApi connection = ConnectionManager.getConnection(connProps);
        try {
            RepositoryItem dirItem = connection.getRepositoryService().getDirectoryItem(directoryItemId);
            String xmlModel = connection.getRepositoryService().loadModel(dirItem);
            XStream xstream = new XStream();
            FWRReport model = (FWRReport)xstream.fromXML(xmlModel);
            loadFWRReport.put(connProps, model);
            return model;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static IRepositoryApi getConnection(Properties connProps) throws Exception {
        String repositoryUrl = connProps.getProperty("REPOSITORY_URL");
        int groupId = Integer.parseInt(connProps.getProperty("GROUP_ID"));
        BaseVanillaContext vanillaContext = new BaseVanillaContext(connProps.getProperty("URL"), connProps.getProperty("USER"), connProps.getProperty("PASSWORD"));
        RemoteVanillaPlatform api = new RemoteVanillaPlatform((IVanillaContext)vanillaContext);
        Group group = api.getVanillaSecurityManager().getGroupById(groupId);
        Repository repository = api.getVanillaRepositoryManager().getRepositoryFromUrl(repositoryUrl);
        BaseRepositoryContext ctx = new BaseRepositoryContext((IVanillaContext)vanillaContext, group, repository);
        return new RemoteRepositoryApi((IRepositoryContext)ctx);
    }
}

