/*
 * Decompiled with CFR 0.152.
 */
package bpm.fwr.oda.runtime.impl;

import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.jdbc.VanillaPreparedStatement;
import bpm.fwr.oda.runtime.impl.Query;
import bpm.metadata.layer.business.IBusinessPackage;
import bpm.vanilla.platform.core.beans.Group;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
extends bpm.metadata.birt.oda.runtime.impl.Connection {
    public static final String URL = "URL";
    public static final String USER = "USER";
    public static final String PASSWORD = "PASSWORD";
    public static final String REPOSITORY_URL = "REPOSITORY_URL";
    public static final String GROUP_ID = "GROUP_ID";
    public static final String GROUP_NAME = "GROUP_NAME";
    public static final String FWREPORT_ID = "FWREPORT_ID";
    public static final String DATASET_NAME = "DATASET_NAME";
    private String repositoryUrl;
    private Integer fwReportId;
    private Integer groupId;

    public void open(Properties connProperties) throws OdaException {
        this.m_isOpen = false;
        if (connProperties == null) {
            throw new OdaException("No Connection Properties Provided.");
        }
        boolean hasChanged = false;
        if (this.username == null || !this.username.equals(connProperties.getProperty(USER))) {
            this.username = connProperties.getProperty(USER);
            hasChanged = true;
        }
        if (this.password == null || !this.password.equals(connProperties.getProperty(PASSWORD))) {
            this.password = connProperties.getProperty(PASSWORD);
            hasChanged = true;
        }
        if (this.repositoryUrl == null || !this.repositoryUrl.equals(connProperties.getProperty(REPOSITORY_URL))) {
            this.repositoryUrl = connProperties.getProperty(REPOSITORY_URL);
            hasChanged = true;
        }
        if (this.groupId == null || this.groupId != Integer.parseInt(connProperties.getProperty(GROUP_ID))) {
            this.groupId = Integer.parseInt(connProperties.getProperty(GROUP_ID));
            hasChanged = true;
        }
        if (this.groupName == null || !this.groupName.equals(connProperties.getProperty(GROUP_NAME))) {
            this.groupName = connProperties.getProperty(GROUP_NAME);
            hasChanged = true;
        }
        if (this.fwReportId == null || this.fwReportId != Integer.parseInt(connProperties.getProperty(FWREPORT_ID))) {
            this.fwReportId = Integer.parseInt(connProperties.getProperty(FWREPORT_ID));
            hasChanged = true;
        }
        if (!hasChanged) {
            this.m_isOpen = true;
            return;
        }
        this.m_isOpen = true;
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
        super.close();
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException("Cannot create query on closed connection");
        }
        VanillaPreparedStatement jdbcStatement = null;
        Group dummy = new Group();
        dummy.setName(this.getGroupName());
        return new Query(this, jdbcStatement, this.fmdtPackage, this.connectionName, dummy);
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public void initFmdtConnection(String connectionName, IBusinessPackage fmdtPack, String groupName, VanillaJdbcConnection jdbcCon, String url, String username, String password) {
        this.setConnectionName(connectionName);
        this.setFmdtPackage(fmdtPack);
        this.setGroupName(groupName);
        this.setJdbcConnection(jdbcCon);
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }
}

