/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.runtime.model;

import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetColumn;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetRow;
import java.util.ArrayList;
import java.util.Collections;

public class OdaGoogleSheet {
    private String sheetName;
    private int sheetIndex;
    private int sheetCountRow;
    private int sheetCountCol;
    private boolean firstRowRemoved;
    private ArrayList<OdaGoogleSheetColumn> sheetListCol;
    private ArrayList<OdaGoogleSheetRow> sheetListRow;

    public OdaGoogleSheet(String sheetName, int sheetIndex, int pCountCol, int pCountRow) {
        this.sheetName = sheetName;
        this.sheetIndex = sheetIndex;
        this.sheetCountCol = pCountCol;
        this.sheetCountRow = pCountRow;
        this.sheetListCol = new ArrayList();
        this.sheetListRow = new ArrayList();
        this.firstRowRemoved = false;
    }

    public void sortColumnsToRemove(String[] listColsSelected) {
        ArrayList<OdaGoogleSheetColumn> listColToRemove = new ArrayList<OdaGoogleSheetColumn>();
        ArrayList<Integer> listCellToRemove = new ArrayList<Integer>();
        for (OdaGoogleSheetColumn col : this.sheetListCol) {
            boolean colFind = false;
            String[] stringArray = listColsSelected;
            int n = listColsSelected.length;
            int n2 = 0;
            while (n2 < n) {
                String colName = stringArray[n2];
                if (colName.equals(col.getColName())) {
                    colFind = true;
                }
                ++n2;
            }
            if (colFind) continue;
            listColToRemove.add(col);
        }
        listCellToRemove.clear();
        for (OdaGoogleSheetColumn col : listColToRemove) {
            listCellToRemove.add(col.getColIndex());
        }
        Collections.sort(listCellToRemove, Collections.reverseOrder());
        for (OdaGoogleSheetRow row : this.sheetListRow) {
            for (Integer indexCell : listCellToRemove) {
                row.getRowListCell().remove(row.getRowListCell().get(indexCell));
            }
        }
        for (OdaGoogleSheetColumn colRemove : listColToRemove) {
            int indexColRemoved = colRemove.getColIndex();
            int i = indexColRemoved + 1;
            while (i < this.sheetCountCol) {
                this.sheetListCol.get(i).decrementIndexCol();
                ++i;
            }
        }
        for (OdaGoogleSheetColumn colRemove : listColToRemove) {
            this.sheetListCol.remove(colRemove);
            --this.sheetCountCol;
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public ArrayList<OdaGoogleSheetColumn> getSheetListCol() {
        return this.sheetListCol;
    }

    public void setSheetListCol(ArrayList<OdaGoogleSheetColumn> sheetListCol) {
        this.sheetListCol = sheetListCol;
    }

    public int getSheetCountRow() {
        return this.sheetCountRow;
    }

    public void setSheetCountRow(int sheetCountRow) {
        this.sheetCountRow = sheetCountRow;
    }

    public int getSheetCountCol() {
        return this.sheetCountCol;
    }

    public void setSheetCountCol(int sheetCountCol) {
        this.sheetCountCol = sheetCountCol;
    }

    public ArrayList<OdaGoogleSheetRow> getSheetListRow() {
        return this.sheetListRow;
    }

    public void setSheetListRow(ArrayList<OdaGoogleSheetRow> sheetListRow) {
        this.sheetListRow = sheetListRow;
    }

    public boolean isFirstRowRemoved() {
        return this.firstRowRemoved;
    }

    public void setFirstRowRemoved(boolean firstRowRemoved) {
        this.firstRowRemoved = firstRowRemoved;
    }
}

