/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.runtime.model;

import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleFilterData;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheet;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetColumn;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetRow;
import java.util.ArrayList;

public class OdaGoogleParameter {
    private String paramColumn;
    private String paramOperator;
    private String paramLogicalOperator;
    private String paramName;
    private Class paramClass;
    private Object paramValue1;
    private static ArrayList<Integer> listIndexRowsHiddenFirst;
    private static ArrayList<Integer> listIndexRowsHiddenNext;
    private static ArrayList<Integer> listIndexRowsHiddenFinal;

    public OdaGoogleParameter() {
    }

    public OdaGoogleParameter(String colParameter, String opeParameter, Class classParameter, String opeLogical) {
        this.paramColumn = colParameter;
        this.paramOperator = opeParameter;
        this.paramLogicalOperator = opeLogical;
        this.paramName = "";
        this.paramClass = classParameter;
        this.paramValue1 = null;
    }

    public OdaGoogleParameter(String colP, String opP) {
        this.paramColumn = colP;
        this.paramOperator = opP;
    }

    public static void updateDataSetWithParameters(OdaGoogleSheet sheetSelected, ArrayList<OdaGoogleParameter> listQueryParameters) {
        listIndexRowsHiddenFirst = new ArrayList();
        listIndexRowsHiddenNext = new ArrayList();
        listIndexRowsHiddenFinal = new ArrayList();
        for (OdaGoogleParameter currentParam : listQueryParameters) {
            listIndexRowsHiddenFirst.clear();
            listIndexRowsHiddenFirst.addAll(listIndexRowsHiddenFinal);
            listIndexRowsHiddenNext.clear();
            int indexCurrentRow = 0;
            for (OdaGoogleSheetRow currentRow : sheetSelected.getSheetListRow()) {
                OdaGoogleParameter.applyCurrentParameter(currentParam, currentRow, sheetSelected, indexCurrentRow);
                ++indexCurrentRow;
            }
            OdaGoogleParameter.applyLogicalFilter(currentParam.paramLogicalOperator);
        }
        int subIndexRow = 0;
        for (OdaGoogleSheetRow rowUpdate : sheetSelected.getSheetListRow()) {
            if (listIndexRowsHiddenFinal.contains(subIndexRow)) {
                rowUpdate.setFiltered(true);
            } else {
                rowUpdate.setFiltered(false);
            }
            ++subIndexRow;
        }
    }

    private static void applyLogicalFilter(String paramLogicalOperator2) {
        listIndexRowsHiddenFinal.clear();
        if (paramLogicalOperator2.equals("++No Logical++") || paramLogicalOperator2.equals(OdaGoogleFilterData.LOGICAL_OPERATORS_TAB[1])) {
            listIndexRowsHiddenFinal.addAll(listIndexRowsHiddenFirst);
            for (Integer rowNext : listIndexRowsHiddenNext) {
                if (listIndexRowsHiddenFinal.contains(rowNext)) continue;
                listIndexRowsHiddenFinal.add(rowNext);
            }
        } else {
            listIndexRowsHiddenFirst.retainAll(listIndexRowsHiddenNext);
            listIndexRowsHiddenNext.retainAll(listIndexRowsHiddenFirst);
            listIndexRowsHiddenFinal.addAll(listIndexRowsHiddenNext);
        }
    }

    private static void applyCurrentParameter(OdaGoogleParameter currentParam, OdaGoogleSheetRow currentRow, OdaGoogleSheet sheetSelected, int indexCurrentRow) {
        String indexOperatorFilter = currentParam.getParamOperator();
        String valueCell = null;
        Class classColConcerned = null;
        int indexColConcerned = 0;
        boolean valueOk = false;
        for (OdaGoogleSheetColumn col : sheetSelected.getSheetListCol()) {
            if (!col.getColName().equals(currentParam.getParamColumn())) continue;
            indexColConcerned = col.getColIndex();
            classColConcerned = col.getColClass();
        }
        try {
            if (classColConcerned == Integer.class) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                Integer.parseInt(valueCell);
                valueOk = true;
            } else if (classColConcerned == Double.class) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                Double.parseDouble(valueCell);
                valueOk = true;
            } else {
                valueOk = true;
            }
        }
        catch (Exception exception) {
            valueOk = false;
        }
        if (!valueOk) {
            currentRow.setFiltered(true);
        } else if (currentParam.getParamValue1() != null) {
            String value1;
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[2])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleParameter.objCompareTo(classColConcerned, valueCell, value1) < 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[3])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleParameter.objCompareTo(classColConcerned, valueCell, value1) <= 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[4])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleParameter.objCompareTo(classColConcerned, valueCell, value1) > 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[5])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleParameter.objCompareTo(classColConcerned, valueCell, value1) >= 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[0])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleParameter.objCompareTo(classColConcerned, valueCell, value1) == 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[1])) {
                value1 = currentParam.getParamValue1().toString();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleParameter.objCompareTo(classColConcerned, valueCell, value1) != 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[8])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null) {
                    currentRow.setFiltered(false);
                } else if (valueCell.toString().equals("0") || valueCell.toString().equals("0.0")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[9])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell != null) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[10])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if ((valueCell = valueCell.toLowerCase()).equals("true")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OdaGoogleFilterData.OPERATORS_TAB[11])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if ((valueCell = valueCell.toLowerCase()).equals("false")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
        }
        if (currentRow.isFiltered()) {
            listIndexRowsHiddenNext.add(indexCurrentRow);
        }
    }

    private static int objCompareTo(Class classObj, String valueData, String valueFilter1) {
        int resultCompare = 0;
        if (classObj == Integer.class) {
            Integer intValueFilter1 = Integer.valueOf(valueFilter1);
            Integer intValueData = Integer.valueOf(valueData.toString());
            resultCompare = intValueData.compareTo(intValueFilter1);
        } else if (classObj == Double.class) {
            Double doubleValueFilter1 = Double.valueOf(valueFilter1);
            Double doubleValueData = Double.valueOf(valueData.toString());
            resultCompare = doubleValueData.compareTo(doubleValueFilter1);
        } else {
            String strValueData = valueData.toString();
            resultCompare = strValueData.compareTo(valueFilter1);
        }
        return resultCompare;
    }

    public String getParamColumn() {
        return this.paramColumn;
    }

    public void setParamColumn(String paramColumn) {
        this.paramColumn = paramColumn;
    }

    public String getParamOperator() {
        return this.paramOperator;
    }

    public void setParamOperator(String paramOperator) {
        this.paramOperator = paramOperator;
    }

    public Class getParamClass() {
        return this.paramClass;
    }

    public void setParamClass(Class paramClass) {
        this.paramClass = paramClass;
    }

    public Object getParamValue1() {
        return this.paramValue1;
    }

    public void setParamValue1(Object paramValue1) {
        this.paramValue1 = paramValue1;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }
}

