/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.runtime.model;

import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheet;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetColumn;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetRow;
import java.util.ArrayList;

public class OdaGoogleFilterData {
    private String nameColFilter;
    private String typeFilter;
    private String value1Filter;
    private String value2Filter;
    private String logicalSeparator;
    private static ArrayList<Integer> listIndexRowsHiddenFirst;
    private static ArrayList<Integer> listIndexRowsHiddenNext;
    private static ArrayList<Integer> listIndexRowsHiddenFinal;
    public static final String[] OPERATORS_TAB;
    public static final int OPERATORS_INDEX_EQUALS = 0;
    public static final int OPERATORS_INDEX_NOT_EQUALS = 1;
    public static final int OPERATORS_INDEX_LESS = 2;
    public static final int OPERATORS_INDEX_LESS_EQUALS = 3;
    public static final int OPERATORS_INDEX_GREATHER = 4;
    public static final int OPERATORS_INDEX_GREATHER_EQUALS = 5;
    public static final int OPERATORS_INDEX_BETWEEN = 6;
    public static final int OPERATORS_INDEX_BETWEEN_NOT = 7;
    public static final int OPERATORS_INDEX_NULL = 8;
    public static final int OPERATORS_INDEX_NULL_NOT = 9;
    public static final int OPERATORS_INDEX_TRUE = 10;
    public static final int OPERATORS_INDEX_FALSE = 11;
    public static final String[] LOGICAL_OPERATORS_TAB;
    public static final int LOGICAL_INDEX_NONE = 0;
    public static final int LOGICAL_INDEX_AND = 1;
    public static final int LOGICAL_INDEX_OR = 2;

    static {
        OPERATORS_TAB = new String[]{"Equals to", "Not equals to", "Less than", "Less than or Equal", "Greather than", "Greather than or equal", "Between", "Not between", "Is null", "Is not null", "Is true", "Is false"};
        LOGICAL_OPERATORS_TAB = new String[]{"", "AND", "OR"};
    }

    public OdaGoogleFilterData(String nameColFilter, String typeFilter, String value1Filter, String value2Filter, String pLogical) {
        this.nameColFilter = nameColFilter;
        this.typeFilter = typeFilter;
        this.value1Filter = value1Filter;
        this.value2Filter = value2Filter;
        this.logicalSeparator = pLogical;
    }

    public static void updateDataSetWithFilters(OdaGoogleSheet listDataSet, ArrayList<OdaGoogleFilterData> listDataSetFilters) {
        listIndexRowsHiddenFirst = new ArrayList();
        listIndexRowsHiddenNext = new ArrayList();
        listIndexRowsHiddenFinal = new ArrayList();
        for (OdaGoogleFilterData currentFilter : listDataSetFilters) {
            int indexCurrentRow = 0;
            listIndexRowsHiddenFirst.clear();
            listIndexRowsHiddenFirst.addAll(listIndexRowsHiddenFinal);
            listIndexRowsHiddenNext.clear();
            for (OdaGoogleSheetRow currentRow : listDataSet.getSheetListRow()) {
                OdaGoogleFilterData.applyCurrentFilter(listDataSet, currentRow, currentFilter, indexCurrentRow);
                ++indexCurrentRow;
            }
            OdaGoogleFilterData.applyLogicalFilter(currentFilter.getLogicalSeparator());
        }
        int subIndexRow = 0;
        for (OdaGoogleSheetRow rowUpdate : listDataSet.getSheetListRow()) {
            if (listIndexRowsHiddenFinal.contains(subIndexRow)) {
                rowUpdate.setFiltered(true);
            } else {
                rowUpdate.setFiltered(false);
            }
            ++subIndexRow;
        }
    }

    private static String test(ArrayList<Integer> list) {
        String s = "";
        for (Integer i : list) {
            s = String.valueOf(s) + i + " ";
        }
        return s;
    }

    private static void applyLogicalFilter(String logicalSeparator2) {
        listIndexRowsHiddenFinal.clear();
        if (logicalSeparator2.equals("++No Logical++") || logicalSeparator2.equals(LOGICAL_OPERATORS_TAB[1])) {
            listIndexRowsHiddenFinal.addAll(listIndexRowsHiddenFirst);
            for (Integer rowNext : listIndexRowsHiddenNext) {
                if (listIndexRowsHiddenFinal.contains(rowNext)) continue;
                listIndexRowsHiddenFinal.add(rowNext);
            }
        } else {
            listIndexRowsHiddenFirst.retainAll(listIndexRowsHiddenNext);
            listIndexRowsHiddenNext.retainAll(listIndexRowsHiddenFirst);
            listIndexRowsHiddenFinal.addAll(listIndexRowsHiddenNext);
        }
    }

    private static void applyCurrentFilter(OdaGoogleSheet listDataSet, OdaGoogleSheetRow currentRow, OdaGoogleFilterData currentFilter, int indexCurrentRow) {
        String indexOperatorFilter = currentFilter.getTypeFilter();
        String valueCell = null;
        Class classColConcerned = null;
        int indexColConcerned = 0;
        boolean valueOk = false;
        for (OdaGoogleSheetColumn col : listDataSet.getSheetListCol()) {
            if (!col.getColName().equals(currentFilter.getNameColFilter())) continue;
            indexColConcerned = col.getColIndex();
            classColConcerned = col.getColClass();
        }
        try {
            if (classColConcerned == Integer.class) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                Integer.parseInt(valueCell);
                valueOk = true;
            } else if (classColConcerned == Double.class) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                Double.parseDouble(valueCell);
                valueOk = true;
            } else {
                valueOk = true;
            }
        }
        catch (Exception exception) {
            valueOk = false;
        }
        if (!valueOk) {
            currentRow.setFiltered(true);
        } else {
            String value2;
            String value1;
            if (indexOperatorFilter.equals(OPERATORS_TAB[2])) {
                value1 = currentFilter.getValue1Filter();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleFilterData.objCompareTo(classColConcerned, valueCell, value1) < 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[3])) {
                value1 = currentFilter.getValue1Filter();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleFilterData.objCompareTo(classColConcerned, valueCell, value1) <= 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[4])) {
                value1 = currentFilter.getValue1Filter();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleFilterData.objCompareTo(classColConcerned, valueCell, value1) > 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[5])) {
                value1 = currentFilter.getValue1Filter();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleFilterData.objCompareTo(classColConcerned, valueCell, value1) >= 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[0])) {
                value1 = currentFilter.getValue1Filter();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleFilterData.objCompareTo(classColConcerned, valueCell, value1) == 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[1])) {
                value1 = currentFilter.getValue1Filter();
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if (OdaGoogleFilterData.objCompareTo(classColConcerned, valueCell, value1) != 0) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[8])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null) {
                    currentRow.setFiltered(false);
                } else if (valueCell.toString().equals("0") || valueCell.toString().equals("0.0")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[9])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell != null) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[10])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if ((valueCell = valueCell.toLowerCase()).equals("true")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[11])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (valueCell == null || valueCell.length() == 0) {
                    currentRow.setFiltered(true);
                } else if ((valueCell = valueCell.toLowerCase()).equals("false")) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[6])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (OdaGoogleFilterData.betweenCompare(valueCell, value1 = currentFilter.getValue1Filter(), value2 = currentFilter.getValue2Filter(), classColConcerned)) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
            if (indexOperatorFilter.equals(OPERATORS_TAB[7])) {
                valueCell = currentRow.getRowListCell().get(indexColConcerned);
                if (!OdaGoogleFilterData.betweenCompare(valueCell, value1 = currentFilter.getValue1Filter(), value2 = currentFilter.getValue2Filter(), classColConcerned)) {
                    currentRow.setFiltered(false);
                } else {
                    currentRow.setFiltered(true);
                }
            }
        }
        if (currentRow.isFiltered()) {
            listIndexRowsHiddenNext.add(indexCurrentRow);
        }
    }

    private static int objCompareTo(Class classObj, String valueData, String valueFilter1) {
        int resultCompare = 0;
        if (classObj == Integer.class) {
            Integer intValueFilter1 = Integer.valueOf(valueFilter1);
            Integer intValueData = Integer.valueOf(valueData.toString());
            resultCompare = intValueData.compareTo(intValueFilter1);
        } else if (classObj == Double.class) {
            Double doubleValueFilter1 = Double.valueOf(valueFilter1);
            Double doubleValueData = Double.valueOf(valueData.toString());
            resultCompare = doubleValueData.compareTo(doubleValueFilter1);
        } else {
            String strValueData = valueData.toString();
            resultCompare = strValueData.compareTo(valueFilter1);
        }
        return resultCompare;
    }

    private static boolean betweenCompare(String valueData, String valueFilter1, String valueFilter2, Class classObj) {
        int comp1 = 2;
        int comp2 = 2;
        if (valueData == null) {
            valueData = "0";
        }
        if (classObj == Integer.class) {
            Integer intValueFilter1 = Integer.valueOf(valueFilter1);
            Integer intValueFilter2 = Integer.valueOf(valueFilter2);
            Integer intValueData = Integer.valueOf(valueData);
            comp1 = intValueFilter1.compareTo(intValueData);
            comp2 = intValueData.compareTo(intValueFilter2);
        } else if (classObj == Double.class) {
            Double intValueFilter1 = Double.valueOf(valueFilter1);
            Double intValueFilter2 = Double.valueOf(valueFilter2);
            Double intValueData = Double.valueOf(valueData);
            comp1 = intValueFilter1.compareTo(intValueData);
            comp2 = intValueData.compareTo(intValueFilter2);
        } else {
            String intValueFilter1 = valueFilter1;
            String intValueFilter2 = valueFilter2;
            String intValueData = valueData;
            comp1 = intValueFilter1.compareTo(intValueData);
            comp2 = intValueData.compareTo(intValueFilter2);
        }
        return comp1 <= 0 && comp2 <= 0;
    }

    private static void updateLine(OdaGoogleSheet listDataSet) {
    }

    public String getNameColFilter() {
        return this.nameColFilter;
    }

    public void setNameColFilter(String nameColFilter) {
        this.nameColFilter = nameColFilter;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(String typeFilter) {
        this.typeFilter = typeFilter;
    }

    public String getValue1Filter() {
        return this.value1Filter;
    }

    public void setValue1Filter(String value1Filter) {
        this.value1Filter = value1Filter;
    }

    public String getValue2Filter() {
        return this.value2Filter;
    }

    public void setValue2Filter(String value2Filter) {
        this.value2Filter = value2Filter;
    }

    public String getLogicalSeparator() {
        return this.logicalSeparator;
    }

    public void setLogicalSeparator(String logicalSeparator) {
        this.logicalSeparator = logicalSeparator;
    }
}

