/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.runtime.impl;

import bpm.google.spreadsheet.oda.driver.runtime.impl.ParameterMetaData;
import bpm.google.spreadsheet.oda.driver.runtime.impl.ResultSet;
import bpm.google.spreadsheet.oda.driver.runtime.impl.ResultSetMetaData;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleFilterData;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleParameter;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheet;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetColumn;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetRow;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class Query
implements IQuery {
    private int m_maxRows;
    private ArrayList<OdaGoogleSheet> listQuerySheets = new ArrayList();
    private ArrayList<OdaGoogleFilterData> listDataSetFilters;
    private ArrayList<OdaGoogleParameter> listQueryParameters;
    private OdaGoogleSheet sheetSelected;
    private ResultSetMetaData resultSetMetaData;
    private ParameterMetaData parameterMetaData;

    public Query(ArrayList<OdaGoogleSheet> listSheets) {
        this.listQuerySheets.addAll(listSheets);
        this.listDataSetFilters = new ArrayList();
        this.listQueryParameters = new ArrayList();
    }

    public void prepare(String queryText) throws OdaException {
        String[] tabElementsQuery = queryText.split("]");
        for (OdaGoogleSheet currentSheet : this.listQuerySheets) {
            if (!currentSheet.getSheetName().equals(tabElementsQuery[0])) continue;
            this.sheetSelected = currentSheet;
        }
        String rowSkipped = tabElementsQuery[1];
        if (rowSkipped.equals("Skip true") && !this.sheetSelected.isFirstRowRemoved() && this.sheetSelected.getSheetListRow().get(0) != null) {
            this.sheetSelected.getSheetListRow().remove(0);
            this.sheetSelected.setSheetCountRow(this.sheetSelected.getSheetCountRow() - 1);
            this.sheetSelected.setFirstRowRemoved(true);
        }
        String queryColSelected = tabElementsQuery[2];
        String[] listColsSelected = queryColSelected.split("!");
        this.sheetSelected.sortColumnsToRemove(listColsSelected);
        String queryColSelectedLabel = tabElementsQuery[3];
        String[] listColsSelectedLabels = queryColSelectedLabel.split("!");
        int indexLabel = 0;
        for (OdaGoogleSheetColumn currentCol : this.sheetSelected.getSheetListCol()) {
            currentCol.setColLabelName(listColsSelectedLabels[indexLabel]);
            ++indexLabel;
        }
        String strQueryFilter = tabElementsQuery[4];
        if (!strQueryFilter.equals("++No filter++")) {
            String[] tabFilters = strQueryFilter.split(";");
            int i = 0;
            while (i < tabFilters.length) {
                String[] subTabFilter = tabFilters[i].split("!");
                if (subTabFilter.length == 3) {
                    this.listDataSetFilters.add(new OdaGoogleFilterData(subTabFilter[0], subTabFilter[1], "++Any Value++", "++Any Value++", subTabFilter[2]));
                } else if (subTabFilter.length == 4) {
                    this.listDataSetFilters.add(new OdaGoogleFilterData(subTabFilter[0], subTabFilter[1], subTabFilter[2], "++Any Value++", subTabFilter[3]));
                } else {
                    this.listDataSetFilters.add(new OdaGoogleFilterData(subTabFilter[0], subTabFilter[1], subTabFilter[2], subTabFilter[3], subTabFilter[4]));
                }
                ++i;
            }
        }
        OdaGoogleFilterData.updateDataSetWithFilters(this.sheetSelected, this.listDataSetFilters);
        ArrayList<OdaGoogleSheetRow> listRowToRemove = new ArrayList<OdaGoogleSheetRow>();
        for (OdaGoogleSheetRow currentRow : this.sheetSelected.getSheetListRow()) {
            if (!currentRow.isFiltered()) continue;
            listRowToRemove.add(currentRow);
        }
        this.sheetSelected.getSheetListRow().removeAll(listRowToRemove);
        this.sheetSelected.setSheetCountRow(this.sheetSelected.getSheetListRow().size());
        String queryParameters = tabElementsQuery[5];
        if (!queryParameters.equals("++No Parameter++")) {
            String[] listParameters;
            String[] stringArray = listParameters = queryParameters.split(";");
            int n = listParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String currentDetailsParam = stringArray[n2];
                String[] detailsParam = currentDetailsParam.split("!");
                String colParameter = detailsParam[0];
                String opeParameter = detailsParam[1];
                Class classParameter = null;
                for (OdaGoogleSheetColumn co : this.sheetSelected.getSheetListCol()) {
                    if (!co.getColName().equals(colParameter)) continue;
                    classParameter = co.getColClass();
                }
                OdaGoogleParameter tempParam = null;
                OdaGoogleParameter tempParam2 = null;
                String tempLogicalAnd = OdaGoogleFilterData.LOGICAL_OPERATORS_TAB[1];
                String tempLogicalOr = OdaGoogleFilterData.LOGICAL_OPERATORS_TAB[2];
                String tempLogicalNull = "++No Logical++";
                if (opeParameter.equals(OdaGoogleFilterData.OPERATORS_TAB[6])) {
                    tempParam = new OdaGoogleParameter(colParameter, OdaGoogleFilterData.OPERATORS_TAB[5], classParameter, tempLogicalNull);
                    tempParam2 = new OdaGoogleParameter(colParameter, OdaGoogleFilterData.OPERATORS_TAB[3], classParameter, tempLogicalAnd);
                } else if (opeParameter.equals(OdaGoogleFilterData.OPERATORS_TAB[7])) {
                    tempParam = new OdaGoogleParameter(colParameter, OdaGoogleFilterData.OPERATORS_TAB[2], classParameter, tempLogicalNull);
                    tempParam2 = new OdaGoogleParameter(colParameter, OdaGoogleFilterData.OPERATORS_TAB[4], classParameter, tempLogicalOr);
                } else {
                    tempParam = new OdaGoogleParameter(colParameter, opeParameter, classParameter, tempLogicalNull);
                }
                if (tempParam2 == null) {
                    tempParam.setParamName("Parameter " + (this.listQueryParameters.size() + 1) + " on " + tempParam.getParamColumn());
                    this.listQueryParameters.add(tempParam);
                } else {
                    tempParam.setParamName("Parameter " + (this.listQueryParameters.size() + 1) + ".1 on " + tempParam.getParamColumn());
                    this.listQueryParameters.add(tempParam);
                    tempParam2.setParamName("Parameter " + this.listQueryParameters.size() + ".2  on " + tempParam.getParamColumn());
                    this.listQueryParameters.add(tempParam2);
                }
                ++n2;
            }
        }
        this.parameterMetaData = new ParameterMetaData(this.listQueryParameters);
        this.resultSetMetaData = new ResultSetMetaData(this.sheetSelected);
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        OdaGoogleParameter.updateDataSetWithParameters(this.sheetSelected, this.listQueryParameters);
        ArrayList<OdaGoogleSheetRow> listRowToRemoveParam = new ArrayList<OdaGoogleSheetRow>();
        for (OdaGoogleSheetRow currentRow : this.sheetSelected.getSheetListRow()) {
            if (!currentRow.isFiltered()) continue;
            listRowToRemoveParam.add(currentRow);
        }
        this.sheetSelected.getSheetListRow().removeAll(listRowToRemoveParam);
        this.sheetSelected.setSheetCountRow(this.sheetSelected.getSheetListRow().size());
        ResultSet resultSet = new ResultSet(this.sheetSelected);
        resultSet.setMaxRows(this.getMaxRows());
        return resultSet;
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.m_maxRows;
    }

    public void clearInParameters() throws OdaException {
        this.listQueryParameters.clear();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setString(String parameterName, String value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(value);
        }
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(value);
    }

    public void setNull(String parameterName) throws OdaException {
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (!currentPara.getParamName().equals(parameterName)) continue;
            currentPara.setParamValue1(null);
        }
    }

    public void setNull(int parameterId) throws OdaException {
        this.listQueryParameters.get(parameterId - 1).setParamValue1(null);
    }

    public int findInParameter(String parameterName) throws OdaException {
        int i = 0;
        int result = 0;
        for (OdaGoogleParameter currentPara : this.listQueryParameters) {
            if (currentPara.getParamName().equals(parameterName)) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return new ParameterMetaData(this.listQueryParameters);
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setParameterMetaData(ParameterMetaData parameterMetaData) {
        this.parameterMetaData = parameterMetaData;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
    }

    public String getEffectiveQueryText() {
        return null;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public void setObject(String parameterName, Object value) throws OdaException {
    }

    public void setObject(int parameterId, Object value) throws OdaException {
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
    }
}

