/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.runtime.impl;

import bpm.google.spreadsheet.oda.driver.runtime.impl.DataSetMetaData;
import bpm.google.spreadsheet.oda.driver.runtime.impl.Query;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleAllValuesSheet;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheet;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetColumn;
import bpm.google.spreadsheet.oda.driver.runtime.model.OdaGoogleSheetRow;
import com.google.gdata.client.spreadsheet.CellQuery;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.spreadsheet.CellEntry;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    private boolean m_isOpen = false;
    private static final String URL_GET_SPREADSHEET = "http://spreadsheets.google.com/feeds/spreadsheets/private/full";
    private SpreadsheetEntry spreadSelected = null;
    private SpreadsheetService myService;
    private OdaGoogleAllValuesSheet listAllValuesSheet;
    private ArrayList<OdaGoogleSheet> listSheets;
    private DateTime lastRead = null;

    public void open(Properties connProperties) throws OdaException {
        String propUser = connProperties.getProperty("P_USER");
        String propPass = connProperties.getProperty("P_PASS");
        String propWork = connProperties.getProperty("P_SPREADSHEET_SELECTED");
        try {
            this.myService = new SpreadsheetService("DataSource SpreadSheet");
            this.myService.setUserCredentials(propUser, propPass);
            URL metafeedUrl = new URL(URL_GET_SPREADSHEET);
            SpreadsheetFeed feed = (SpreadsheetFeed)this.myService.getFeed(metafeedUrl, SpreadsheetFeed.class);
            List spreadsheets = feed.getEntries();
            SpreadsheetEntry entry = null;
            int i = 0;
            while (i < spreadsheets.size()) {
                entry = (SpreadsheetEntry)spreadsheets.get(i);
                if (entry.getTitle().getPlainText().equals(propWork)) {
                    this.spreadSelected = entry;
                }
                ++i;
            }
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        try {
            this.initListSheets();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException((Throwable)e);
        }
        this.m_isOpen = true;
    }

    private Class findType(String s) {
        boolean isDouble;
        boolean isInteger;
        try {
            Integer.valueOf(s);
            isInteger = true;
        }
        catch (Exception exception) {
            isInteger = false;
        }
        try {
            Double.valueOf(s);
            isDouble = true;
        }
        catch (Exception exception) {
            isDouble = false;
        }
        if (isInteger) {
            return Integer.class;
        }
        if (isDouble) {
            return Double.class;
        }
        return String.class;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        try {
            this.initListSheets();
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
        return new Query(this.listSheets);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public ArrayList<OdaGoogleSheet> getListSheets() {
        return new ArrayList<OdaGoogleSheet>(this.listSheets);
    }

    public void setListSheets(ArrayList<OdaGoogleSheet> listSheets) {
        this.listSheets = listSheets;
    }

    public void setLocale(ULocale locale) throws OdaException {
    }

    private void initListSheets() throws Exception {
        if (this.lastRead == null) {
            this.lastRead = new DateTime(new Date());
        } else {
            URL metafeedUrl = new URL(URL_GET_SPREADSHEET);
            SpreadsheetFeed feed = (SpreadsheetFeed)this.myService.getFeed(metafeedUrl, SpreadsheetFeed.class);
            List spreadsheets = feed.getEntries();
            SpreadsheetEntry entry = null;
            int i = 0;
            while (i < spreadsheets.size()) {
                entry = (SpreadsheetEntry)spreadsheets.get(i);
                if (entry.getTitle().getPlainText().equals(this.spreadSelected.getTitle().getPlainText())) {
                    if (entry.getUpdated().compareTo((Object)this.lastRead) <= 0) {
                        return;
                    }
                    this.spreadSelected = entry;
                }
                ++i;
            }
        }
        List worksheets = null;
        try {
            worksheets = this.spreadSelected.getWorksheets();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new Exception("Error when get Worksheets" + e1.getMessage(), e1);
        }
        this.listAllValuesSheet = new OdaGoogleAllValuesSheet();
        this.listSheets = new ArrayList();
        int i = 0;
        while (i < worksheets.size()) {
            WorksheetEntry worksheet = (WorksheetEntry)worksheets.get(i);
            String title = worksheet.getTitle().getPlainText();
            int rowCount = worksheet.getRowCount();
            int colCount = worksheet.getColCount();
            try {
                URL cellFeedUrl = worksheet.getCellFeedUrl();
                CellQuery query = new CellQuery(cellFeedUrl);
                query.setMaximumRow(Integer.valueOf(rowCount));
                query.setMaximumCol(Integer.valueOf(colCount));
                query.setReturnEmpty(true);
                CellFeed feed = (CellFeed)this.myService.query((com.google.gdata.client.Query)query, CellFeed.class);
                this.listAllValuesSheet.setListValues(new ArrayList<String>());
                int indCell = 0;
                while (indCell < feed.getEntries().size()) {
                    this.listAllValuesSheet.getListValues().add(((CellEntry)feed.getEntries().get(indCell)).getCell().getValue());
                    ++indCell;
                }
                this.listAllValuesSheet.extractColumns(colCount, rowCount);
                int newCountCol = this.listAllValuesSheet.getCountSortedCol();
                OdaGoogleSheet sheet = new OdaGoogleSheet(title, i, newCountCol, rowCount);
                int indexColTemp = 0;
                for (String colName : this.listAllValuesSheet.getListSortedCol()) {
                    OdaGoogleSheetColumn col = new OdaGoogleSheetColumn(indexColTemp, i, colName);
                    ++indexColTemp;
                    sheet.getSheetListCol().add(col);
                }
                int indexRow = 0;
                while (indexRow < rowCount) {
                    OdaGoogleSheetRow row = new OdaGoogleSheetRow();
                    for (OdaGoogleSheetColumn currentCol : sheet.getSheetListCol()) {
                        String cell = this.listAllValuesSheet.getListValues().get(indexRow * newCountCol + currentCol.getColIndex());
                        row.getRowListCell().add(cell);
                    }
                    sheet.getSheetListRow().add(row);
                    ++indexRow;
                }
                indexRow = 0;
                int indexRowComplete = -1;
                while (indexRow < sheet.getSheetCountRow() && indexRowComplete == -1) {
                    boolean isCellsEmpty = false;
                    for (String currentCell : sheet.getSheetListRow().get(indexRow).getRowListCell()) {
                        if (currentCell != null) continue;
                        isCellsEmpty = true;
                    }
                    if (!isCellsEmpty) {
                        indexRowComplete = indexRow;
                    }
                    ++indexRow;
                }
                int indexCurrentColumn = 0;
                for (String ce : sheet.getSheetListRow().get(indexRowComplete).getRowListCell()) {
                    Class classCell = this.findType(ce);
                    sheet.getSheetListCol().get(indexCurrentColumn).setColClass(classCell);
                    ++indexCurrentColumn;
                }
                boolean endSheet = false;
                int index = 0;
                int lastIndex = -1;
                while (!endSheet && index < sheet.getSheetCountRow()) {
                    int countEmtyCell = 0;
                    for (String currentCell : sheet.getSheetListRow().get(index).getRowListCell()) {
                        if (currentCell == null) {
                            ++countEmtyCell;
                            continue;
                        }
                        if (currentCell.length() != 0) continue;
                        ++countEmtyCell;
                    }
                    if (countEmtyCell == sheet.getSheetCountCol()) {
                        endSheet = true;
                        lastIndex = index;
                    }
                    ++index;
                }
                ArrayList<OdaGoogleSheetRow> listRowToRemove = new ArrayList<OdaGoogleSheetRow>();
                if (lastIndex != -1) {
                    int ind = lastIndex;
                    while (ind < sheet.getSheetCountRow()) {
                        listRowToRemove.add(sheet.getSheetListRow().get(ind));
                        ++ind;
                    }
                }
                if (!listRowToRemove.isEmpty()) {
                    sheet.getSheetListRow().removeAll(listRowToRemove);
                    sheet.setSheetCountRow(sheet.getSheetListRow().size());
                }
                this.listSheets.add(sheet);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

